/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.general.BbanStructure;
import de.adorsys.ledgers.middleware.api.domain.general.RecoveryPointTO;
import de.adorsys.ledgers.middleware.api.domain.um.UploadedDataTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Currency;
import java.util.List;
import java.util.Set;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Tag(name="LDG012 - Data management (STAFF access)")
public interface DataMgmtStaffAPI {
    public static final String BASE_PATH = "/staff-access/data";

    @DeleteMapping(value={"/transactions/{accountId}"})
    @Operation(summary="Removes all transactions for account")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<Void> account(@PathVariable(value="accountId") String var1);

    @DeleteMapping(value={"/account/{accountId}"})
    @Operation(summary="Removes account")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<Void> depositAccount(@PathVariable(value="accountId") String var1);

    @DeleteMapping(value={"/user/{userId}"})
    @Operation(summary="Removes user")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<Void> user(@PathVariable(value="userId") String var1);

    @DeleteMapping(value={"/branch/{branchId}"})
    @Operation(summary="Removes all data related to TPP")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<Void> branch(@PathVariable(value="branchId") String var1);

    @Operation(summary="Upload data to Ledgers (users, accounts, transactions, balances)")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @PostMapping(value={"/upload"})
    public ResponseEntity<Void> uploadData(@RequestBody UploadedDataTO var1);

    @Operation(summary="Retrieve the currencies list supported by ASPSP")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @GetMapping(value={"/currencies"})
    public ResponseEntity<Set<Currency>> currencies();

    @Operation(summary="Get next free branch id for country")
    @PostMapping(value={"/branch"})
    public ResponseEntity<String> branchId(@RequestBody BbanStructure var1);

    @Operation(summary="Create Recovery point")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @PostMapping(value={"/point"})
    public ResponseEntity<Void> createPoint(@RequestBody RecoveryPointTO var1);

    @Operation(summary="Get all Recovery points related to current branch")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @GetMapping(value={"/point/all"})
    public ResponseEntity<List<RecoveryPointTO>> getAllPoints();

    @Operation(summary="Get Recovery point by id related to current branch")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @GetMapping(value={"/point/{id}"})
    public ResponseEntity<RecoveryPointTO> getPoint(@PathVariable(value="id") Long var1);

    @Operation(summary="Deletes Recovery point by id related to current branch")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @DeleteMapping(value={"/point/{id}"})
    public ResponseEntity<Void> deletePoint(@PathVariable(value="id") Long var1);
}

