/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Tag(name="LDG005 - Consent", description="Provide an API to manage consent at the core banking level.")
public interface ConsentRestAPI {
    public static final String BASE_PATH = "/consents";

    @PostMapping(value={"/{consentId}"})
    @Operation(summary="Initiate AIS consent", description="Validates AIS consent and stores consent initiation to DB")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<SCAConsentResponseTO> initiateAisConsent(@PathVariable(value="consentId") String var1, @RequestBody AisConsentTO var2);

    @PostMapping(value={"/piis"})
    @Operation(summary="Generate a consent token for CiF", description="Generate a consent token for CiF. There is no sca process need as we assume the caller is fully authenticated.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<SCAConsentResponseTO> initiatePiisConsent(@RequestBody AisConsentTO var1);
}

