/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.sca.AuthConfirmationTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="LDG002 - User Management", description="Provides endpoint for registering, authorizing and managing users.")
public interface UserMgmtRestAPI {
    public static final String BASE_PATH = "/users";

    @GetMapping(value={"/multilevel"})
    @Operation(tags={"LDG015 - Unprotected Endpoints"}, summary="Check if multilevel SCA required for certain user")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Boolean.class))}, description="Boolean representation of requirement for multi-level sca")})
    public ResponseEntity<Boolean> multilevel(@RequestParam(value="login") String var1, @RequestParam(value="ibanParam") String var2);

    @PostMapping(value={"/multilevel"})
    @Operation(tags={"LDG015 - Unprotected Endpoints"}, summary="Check if multilevel SCA required for certain user")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Boolean.class))}, description="Boolean representation of requirement for multi-level sca")})
    public ResponseEntity<Boolean> multilevelAccounts(@RequestParam(value="login") String var1, @RequestBody List<AccountReferenceTO> var2);

    @PostMapping(value={"/register"})
    @Operation(tags={"LDG015 - Unprotected Endpoints"}, summary="Register", description="Registers a user.<ul><li>A user is always registered as customer and is activated by default.</li><li>A user can only be given another role by an administrating STAFF member.</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UserTO.class))}, description="The user data record without the user pin."), @ApiResponse(responseCode="409", description="Conflict. A user with email or login name already exist.")})
    public ResponseEntity<UserTO> register(@RequestParam(value="login") String var1, @RequestParam(value="email") String var2, @RequestParam(value="pin") String var3, @RequestParam(name="role", defaultValue="CUSTOMER") UserRoleTO var4);

    @GetMapping(value={"/me"})
    @Operation(summary="Current User", description="Retrieves the current usder.<ul><li>The idetifying information (userId=accessToken.sub) is implied from the security context information</li><li>Will send back a 500 if the token is valid and the user is not found. This rather means that the user has been deleted since producing this token in a preceeding step might have implied the existence of the user.</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UserTO.class))}, description="The user data record without the user pin."), @ApiResponse(responseCode="401", description="Provided bearer token could not be verified.")})
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<UserTO> getUser();

    @PutMapping(value={"/me"})
    @Operation(summary="Edit current User")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<Void> editSelf(@RequestBody UserTO var1);

    @PutMapping(value={"/sca-data"})
    @Operation(summary="Updates user SCA", description="Updates user authentication methods.<lu><li>User is implied from the provided access token.</li><li>Actor token (delegation token like ais cosent token) can not be used to execute this operation</li></ul>")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The user data record without the user pin."), @ApiResponse(responseCode="401", description="Provided bearer token could not be verified."), @ApiResponse(responseCode="403", description="Provided bearer token not qualified for this operation.")})
    public ResponseEntity<Void> updateUserScaData(@RequestBody List<ScaUserDataTO> var1);

    @GetMapping(value={"/{userId}"})
    @Operation(summary="Retrieves User by ID", description="Retrieves User by ID<lu><li>This can only be called by either SYSTEM or STAFF members.</li><li>Will be moved to a management interface in the future.</li></lu>")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<UserTO> getUserById(@PathVariable(value="userId") String var1);

    @PutMapping(value={"/authorisations/{authorisationId}/confirmation/{authConfirmCode}"})
    @Operation(summary="Send an authentication confirmation code for validation", description="Validate an authentication code")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<AuthConfirmationTO> verifyAuthConfirmationCode(@PathVariable(value="authorisationId") String var1, @PathVariable(name="authConfirmCode") String var2);

    @PutMapping(value={"/authorisations/{authorisationId}/confirmation"})
    @Operation(summary="Send an authentication confirmation code for validation", description="Validate an authentication code")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<AuthConfirmationTO> completeAuthConfirmation(@PathVariable(value="authorisationId") String var1, @RequestParam(value="authCodeConfirmed", defaultValue="false") boolean var2);

    @PostMapping(value={"/reset/password/{login}"})
    @Operation(summary="Reset password via email", description="Send link for password reset to user email.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Send link to user email for password reset."), @ApiResponse(responseCode="404", description="Conflict. A user with email not found.")})
    public ResponseEntity<Void> resetPasswordViaEmail(@PathVariable(value="login") String var1);
}

