/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="LDG013 - Admin Management (SYSTEM access)")
public interface AdminResourceAPI {
    public static final String BASE_PATH = "/admin";

    @Operation(summary="Lists all users, un-paged")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @GetMapping(value={"users/all"})
    public ResponseEntity<List<UserTO>> getAllUsers();

    @Operation(summary="Get users with filtering", description="Retrieves Page of Users with multiple filters")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @GetMapping(value={"/users"})
    public ResponseEntity<CustomPageImpl<UserExtendedTO>> users(@RequestParam(value="country", defaultValue="", required=false) String var1, @RequestParam(value="branchId", defaultValue="", required=false) String var2, @RequestParam(value="branchLogin", defaultValue="", required=false) String var3, @RequestParam(value="userLogin", defaultValue="", required=false) String var4, @RequestParam(value="role", required=false) UserRoleTO var5, @RequestParam(value="blockedParam", required=false) Boolean var6, @RequestParam(value="page") int var7, @RequestParam(value="size") int var8);

    @Operation(summary="Get users with System role", description="Retrieves Page of Users with System role")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @GetMapping(value={"/admins"})
    public ResponseEntity<CustomPageImpl<UserTO>> admins(@RequestParam(value="page") int var1, @RequestParam(value="size") int var2);

    @Operation(summary="Get accounts with filtering", description="Retrieves Page of Accounts with multiple filters")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @GetMapping(value={"/accounts"})
    public ResponseEntity<CustomPageImpl<AccountDetailsExtendedTO>> accounts(@RequestParam(value="country", defaultValue="", required=false) String var1, @RequestParam(value="branchId", defaultValue="", required=false) String var2, @RequestParam(value="branchLogin", defaultValue="", required=false) String var3, @RequestParam(value="ibanParam", required=false, defaultValue="") String var4, @RequestParam(value="blockedParam", required=false) Boolean var5, @RequestParam(value="page") int var6, @RequestParam(value="size") int var7);

    @Operation(summary="Set password for Branch", description="Changes password for Branch")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @PutMapping(value={"/password"})
    public ResponseEntity<Void> updatePassword(@RequestParam(value="branchId") String var1, @RequestParam(value="password") String var2);

    @Operation(summary="Block/Unblock user", description="Changes system block or regular block state for given user, returns status being set to the block")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @PostMapping(value={"/status"})
    public ResponseEntity<Boolean> changeStatus(@RequestParam(value="userId") String var1);

    @Operation(summary="Create new User by Admin", description="Can create STAFF/CUSTOMER/SYSTEM users")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @PostMapping(value={"/user"})
    public ResponseEntity<UserTO> register(@RequestBody UserTO var1);

    @Operation(summary="Update user", description="Update user")
    @PutMapping(value={"/users"})
    public ResponseEntity<Void> user(@RequestBody UserTO var1);
}

