/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReportTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="LDG011 - Accounts (STAFF access)", description="Provides access to the deposit account resource for staff members.")
public interface AccountMgmStaffResourceAPI {
    public static final String BASE_PATH = "/staff-access/accounts";

    @Operation(summary="Retrieves account by iban and Currency")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Account creation successful"), @ApiResponse(responseCode="404", description="User with this ID not found"), @ApiResponse(responseCode="409", description="Account with given IBAN already exists.")})
    @GetMapping(value={"/acc/acc"})
    public ResponseEntity<List<AccountDetailsTO>> getAccountsByIbanAndCurrency(@RequestParam(name="ibanParam") String var1, @RequestParam(name="currency", required=false, defaultValue="") String var2);

    @Operation(summary="Registers a new Deposit Account for a user with specified ID", description="Registers a new deposit account and assigns account access OWNER to the current user.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Account creation successful"), @ApiResponse(responseCode="404", description="User with this ID not found"), @ApiResponse(responseCode="409", description="Account with given IBAN already exists.")})
    @PostMapping
    public ResponseEntity<Void> createDepositAccountForUser(@RequestParam(name="userId") String var1, @RequestBody AccountDetailsTO var2);

    @Operation(summary="List fo Accessible Accounts", description="Returns the list of all accounts linked to the connected user. Call only available to role CUSTOMER.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AccountDetailsTO[].class))}, description="List of accounts accessible to the user.")})
    @GetMapping
    public ResponseEntity<List<AccountDetailsTO>> getListOfAccounts();

    @Operation(summary="List fo Accessible Accounts", description="Returns the list of all accounts linked to the connected user, paged view. Query param represents full or partial IBAN")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AccountDetailsTO[].class))}, description="List of accounts accessible to the user.")})
    @GetMapping(path={"/page"})
    public ResponseEntity<CustomPageImpl<AccountDetailsTO>> getListOfAccountsPaged(@RequestParam(value="queryParam", defaultValue="", required=false) String var1, @RequestParam(value="page") int var2, @RequestParam(value="size") int var3, @RequestParam(value="withBalance") boolean var4);

    @Operation(summary="Load Account by AccountId", description="Returns account details information for the given account id. User must have access to the target account. This is also accessible to other token types like tpp token (DELEGATED_ACESS)")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AccountDetailsTO.class))}, description="Account details.")})
    @GetMapping(value={"/{accountId}"})
    public ResponseEntity<AccountDetailsTO> getAccountDetailsById(@Parameter(name="accountId") @PathVariable(value="accountId") String var1);

    @Operation(summary="Deposit Cash", description="Operation for staff member to register cash in the deposit account")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Operation was successful")})
    @PostMapping(value={"/{accountId}/cash"})
    public ResponseEntity<Void> depositCash(@PathVariable(value="accountId") String var1, @RequestBody AmountTO var2);

    @Operation(summary="Load Extended Account Details by AccountId", description="Returns extended account details information for the given account id. User must have access to the target account. This is also accessible to other token types like tpp token (DELEGATED_ACESS)")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AccountReportTO.class))}, description="Extended Account details.")})
    @GetMapping(value={"/{accountId}/extended"})
    public ResponseEntity<AccountReportTO> getExtendedAccountDetailsById(@Parameter(name="accountId") @PathVariable(value="accountId") String var1);

    @Operation(summary="Block/Unblock account", description="Changes block state for given account, returns status being set to the block")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @PostMapping(value={"/{accountId}/status"})
    public ResponseEntity<Boolean> changeStatus(@PathVariable(value="accountId") String var1);

    @Operation(summary="Update Credit Limit for specific account account")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @PutMapping(value={"/{accountId}/credit"})
    public ResponseEntity<Void> changeCreditLimit(@PathVariable(value="accountId") String var1, @RequestBody BigDecimal var2);
}

