/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.general.RevertRequestTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="LDG010 - User Management (STAFF access)")
public interface UserMgmtStaffResourceAPI {
    public static final String BASE_PATH = "/staff-access/users";
    public static final String BRANCH = "branch";
    public static final String ROLES = "roles";
    public static final String QUERY_PARAM = "queryParam";
    public static final String BLOCKED = "blockedParam";
    public static final String PAGE = "page";
    public static final String SIZE = "size";
    public static final String USER_ID = "userId";
    public static final String USER_NOT_IN_BRANCH = "User is not your branch";
    public static final String USER_CANNOT_REGISTER_IN_BRANCH = "User cannot register for this branch. The branch is occupied by other user";

    @Operation(tags={"LDG015 - Unprotected Endpoints"}, summary="Register", description="Registers a new user for a given branch.")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UserTO.class))}, description="The user data record without the pin."), @ApiResponse(responseCode="409", description="Conflict. A record with the given email or login already exists.")})
    @PostMapping(value={"/register"})
    public ResponseEntity<UserTO> register(@RequestParam(value="branch") String var1, @RequestBody UserTO var2);

    @Operation(summary="Modify user", description="Modify existing user within the same branch as creator.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UserTO.class))}, description="Success. Updated user is provided in the response."), @ApiResponse(responseCode="401", description="Wrong authentication credential."), @ApiResponse(responseCode="403", description="Authenticated but user does not have the requested role.")})
    @PostMapping(value={"/modify"})
    public ResponseEntity<UserTO> modifyUser(@RequestParam(value="branch") String var1, @RequestBody UserTO var2);

    @Operation(summary="Create user", description="Create new user with the same branch as creator.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UserTO.class))}, description="Success. Created user in provided in the response."), @ApiResponse(responseCode="401", description="Wrong authentication credential."), @ApiResponse(responseCode="403", description="Authenticated but user does not have the requested role.")})
    @PostMapping
    public ResponseEntity<UserTO> createUser(@RequestBody UserTO var1);

    @Operation(summary="Lists users by branch and role", description="Lists users by branch and roles.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UserTO.class))}, description="Success. Created user in provided in the response."), @ApiResponse(responseCode="401", description="Wrong authentication credential."), @ApiResponse(responseCode="403", description="Authenticated but user does not have the requested role.")})
    @GetMapping
    public ResponseEntity<CustomPageImpl<UserTO>> getBranchUsersByRoles(@RequestParam(value="roles") List<UserRoleTO> var1, @RequestParam(value="queryParam", defaultValue="", required=false) String var2, @RequestParam(value="blockedParam", required=false) Boolean var3, @RequestParam(value="page") int var4, @RequestParam(value="size") int var5);

    @Operation(summary="Lists user logins by branch", description="Lists user logins by branch.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UserTO.class))}, description="Success. List of logins received."), @ApiResponse(responseCode="401", description="Wrong authentication credential."), @ApiResponse(responseCode="403", description="Authenticated but user does not have the requested role.")})
    @GetMapping(value={"/logins"})
    public ResponseEntity<List<String>> getBranchUserLogins();

    @Operation(summary="Gets user by ID if it's within the branch", description="Gets user by ID if it's within the branch.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UserTO.class))}, description="Success. Created user in provided in the response."), @ApiResponse(responseCode="401", description="Wrong authentication credential."), @ApiResponse(responseCode="403", description="Authenticated but user does not have the requested role.")})
    @GetMapping(value={"/{userId}"})
    public ResponseEntity<UserTO> getBranchUserById(@PathVariable(value="userId") String var1);

    @Operation(summary="Updates SCA Data for user if it's within the branch.", description="Updates SCA Data for user if it's within the branch.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UserTO.class))}, description="Success. Created user in provided in the response."), @ApiResponse(responseCode="401", description="Wrong authentication credential."), @ApiResponse(responseCode="403", description="Authenticated but user does not have the requested role.")})
    @PostMapping(value={"/{userId}/sca-data"})
    public ResponseEntity<Void> updateUserScaData(@PathVariable(value="userId") String var1, @RequestBody List<ScaUserDataTO> var2);

    @Operation(summary="Grants/Updates Account Access for user.", description="Grants/Updates Account Access for user.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success. Account Access Successfully updated."), @ApiResponse(responseCode="401", description="Wrong authentication credential."), @ApiResponse(responseCode="403", description="Authenticated but user does not have the requested role.")})
    @PutMapping(value={"/access/{userId}"})
    public ResponseEntity<Void> updateAccountAccessForUser(@PathVariable(value="userId") String var1, @RequestBody AccountAccessTO var2);

    @Operation(summary="Block/Unblock user", description="Changes block state for given user, returns status being set to the block")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @PostMapping(value={"/{userId}/status"})
    public ResponseEntity<Boolean> changeStatus(@PathVariable(value="userId") String var1);

    @PostMapping(value={"/revert"})
    @Operation(summary="Reverts DB state for given user to the given date and time.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<Void> revertDatabase(@RequestBody RevertRequestTO var1);
}

