/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="LDG004 - Payment", description="Provide endpoint for initiating and executing payment.")
public interface PaymentRestAPI {
    public static final String BASE_PATH = "/payments";

    @GetMapping(value={"/{paymentId}/status"})
    @Operation(summary="Read Payment Status", description="Returns the status of a payment")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<TransactionStatusTO> getPaymentStatusById(@PathVariable(value="paymentId") String var1);

    @GetMapping(value={"/{paymentId}"})
    @Operation(summary="Load Payment", description="Returns the payment")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<PaymentTO> getPaymentById(@PathVariable(name="paymentId") String var1);

    @GetMapping(value={"/pending/periodic"})
    @Operation(summary="Load Pending Periodic Payments", description="Returns a list of pending periodic payment")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<List<PaymentTO>> getPendingPeriodicPayments();

    @PostMapping(params={"paymentType"})
    @Operation(summary="Initiates a Payment", description="Initiates a payment")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<SCAPaymentResponseTO> initiatePayment(@RequestParam(value="paymentType") PaymentTypeTO var1, @RequestBody PaymentTO var2);

    @PostMapping(value={"/{paymentId}/execution"})
    @Operation(summary="Executes a Payment", description="Confirms payment execution")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<SCAPaymentResponseTO> executePayment(@PathVariable(value="paymentId") String var1);

    @PostMapping(value={"/{paymentId}/cancellation-authorisations"})
    @Operation(summary="Initiates a Payment Cancellation", description="Initiates a Payment Cancellation")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<SCAPaymentResponseTO> initiatePmtCancellation(@PathVariable(value="paymentId") String var1);

    @PostMapping(value={"/{paymentId}/cancellation-authorisations/execute"})
    @Operation(summary="Executes a Payment Cancellation", description="Confirms payment cancellation execution")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<SCAPaymentResponseTO> executeCancelPayment(@PathVariable(value="paymentId") String var1);
}

