/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.oauth.OauthCodeResponseTO;
import de.adorsys.ledgers.middleware.api.domain.oauth.OauthServerInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="LDG06 - Oauth authorisation")
public interface OauthRestApi {
    public static final String BASE_PATH = "/oauth";

    @PostMapping(value={"/authorise"})
    @Operation(summary="Get authorisation code")
    public ResponseEntity<OauthCodeResponseTO> oauthCode(@RequestParam(value="login") String var1, @RequestParam(value="pin") String var2, @RequestParam(value="redirect_uri") String var3);

    @PostMapping(value={"/authorise/oauth"})
    @Operation(summary="Get authorisation code, with token")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<OauthCodeResponseTO> oauthCode(@RequestParam(value="redirect_uri") String var1);

    @PostMapping(value={"/token"})
    @Operation(summary="Get/refresh access token")
    public ResponseEntity<BearerTokenTO> oauthToken(@RequestParam(value="code") String var1);

    @GetMapping(value={"/authorization-server"})
    @Operation(summary="Authorization server metadata request")
    public ResponseEntity<OauthServerInfoTO> oauthServerInfo();
}

