/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountIdentifierTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.AdditionalAccountInformationTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDate;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="LDG003 - Accounts", description="Provides access to a deposit account. This interface does not provide any endpoint to list all accounts.")
public interface AccountRestAPI {
    public static final String BASE_PATH = "/accounts";
    public static final String LOCAL_DATE_YYYY_MM_DD_FORMAT = "yyyy-MM-dd";
    public static final String DATE_TO_QUERY_PARAM = "dateTo";
    public static final String DATE_FROM_QUERY_PARAM = "dateFrom";
    public static final String ACCOUNT_ID = "accountId";
    public static final String TRANSACTION_ID = "transactionId";
    public static final String PAGE = "page";
    public static final String SIZE = "size";

    @GetMapping
    @Operation(summary="List fo Accessible Accounts", description="Returns the list of all accounts linked to the connected user. Call only available to role CUSTOMER.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AccountDetailsTO.class))}, description="List of accounts accessible to the user.")})
    public ResponseEntity<List<AccountDetailsTO>> getListOfAccounts();

    @GetMapping(value={"/{accountId}"})
    @Operation(summary="Load Account by AccountId", description="Returns account details information for the given account id. User must have access to the target account. This is also accessible to other token types like tpp token (DELEGATED_ACESS)")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AccountDetailsTO.class))}, description="Account details.")})
    public ResponseEntity<AccountDetailsTO> getAccountDetailsById(@Parameter(name="accountId") @PathVariable(name="accountId") String var1);

    @GetMapping(value={"/{accountId}/balances"})
    @Operation(summary="Read balances", description="Returns balances of the deposit account with the given accountId. User must have access to the target account. This is also accessible to other token types like tpp token (DELEGATED_ACESS)")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AccountBalanceTO.class))}, description="List of accounts balances for the given account.")})
    public ResponseEntity<List<AccountBalanceTO>> getBalances(@Parameter(name="accountId") @PathVariable(name="accountId") String var1);

    @GetMapping(path={"/{accountId}/transactions"}, params={"dateFrom", "dateTo"})
    @Operation(summary="Find Transactions By Date", description="Returns all transactions for the given account id")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<List<TransactionTO>> getTransactionByDates(@Parameter(name="accountId") @PathVariable(name="accountId") String var1, @RequestParam(name="dateFrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate var2, @RequestParam(name="dateTo") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate var3);

    @GetMapping(path={"/{accountId}/transactions/page"}, params={"dateFrom", "dateTo", "page", "size"})
    @Operation(summary="Find Transactions By Date", description="Returns transactions for the given account id for certain dates, paged view")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<CustomPageImpl<TransactionTO>> getTransactionByDatesPaged(@Parameter(name="accountId") @PathVariable(name="accountId") String var1, @RequestParam(name="dateFrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate var2, @RequestParam(name="dateTo") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate var3, @RequestParam(value="page") int var4, @RequestParam(value="size") int var5);

    @GetMapping(value={"/{accountId}/transactions/{transactionId}"})
    @Operation(summary="Load Transaction", description="Returns the transaction with the given account id and transaction id.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<TransactionTO> getTransactionById(@Parameter(name="accountId") @PathVariable(name="accountId") String var1, @Parameter(name="transactionId") @PathVariable(name="transactionId") String var2);

    @Operation(summary="Fund Confirmation", description="Returns account details information given the account IBAN")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    @PostMapping(value={"/funds-confirmation"})
    public ResponseEntity<Boolean> fundsConfirmation(@RequestBody FundsConfirmationRequestTO var1);

    @GetMapping(path={"/info/{accountIdentifierType}/{accountIdentifier}"})
    @Operation(summary="Load Account Owner Additional information", description="Returns Additional Account Information by Account Identifier")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<List<AdditionalAccountInformationTO>> getAdditionalAccountInfo(@Parameter(description="Account identifier type i.e. ACCOUNT_ID / IBAN") @PathVariable(name="accountIdentifierType") AccountIdentifierTypeTO var1, @Parameter(description="The IBAN of the requested account: e.g.: DE69760700240340283600", example="DE69760700240340283600") @PathVariable(name="accountIdentifier") String var2);
}

