/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.exception;

import de.adorsys.ledgers.util.exception.UserManagementErrorCode;
import java.util.EnumMap;
import org.springframework.http.HttpStatus;

public class UserManagementHttpStatusResolver {
    private static final EnumMap<UserManagementErrorCode, HttpStatus> container = new EnumMap(UserManagementErrorCode.class);

    private UserManagementHttpStatusResolver() {
    }

    public static HttpStatus resolveHttpStatusByCode(UserManagementErrorCode code) {
        return container.get(code);
    }

    static {
        container.put(UserManagementErrorCode.USER_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(UserManagementErrorCode.CONSENT_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(UserManagementErrorCode.TOKEN_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(UserManagementErrorCode.TOKEN_CREATION_ERROR, HttpStatus.BAD_REQUEST);
        container.put(UserManagementErrorCode.RESET_PASSWORD_CODE_SENDING_ERROR, HttpStatus.BAD_REQUEST);
        container.put(UserManagementErrorCode.RESET_PASSWORD_CODE_INVALID, HttpStatus.BAD_REQUEST);
        container.put(UserManagementErrorCode.DUPLICATE_SCA, HttpStatus.BAD_REQUEST);
        container.put(UserManagementErrorCode.INVALID_VERIFICATION_TOKEN, HttpStatus.BAD_REQUEST);
        container.put(UserManagementErrorCode.INSUFFICIENT_PERMISSION, HttpStatus.UNAUTHORIZED);
        container.put(UserManagementErrorCode.INVALID_CREDENTIAL, HttpStatus.UNAUTHORIZED);
        container.put(UserManagementErrorCode.OAUTH_CODE_INVALID, HttpStatus.FORBIDDEN);
        container.put(UserManagementErrorCode.EXPIRED_TOKEN, HttpStatus.FORBIDDEN);
        container.put(UserManagementErrorCode.USER_IS_BLOCKED, HttpStatus.FORBIDDEN);
        container.put(UserManagementErrorCode.USER_IS_TEMPORARY_BLOCKED_BY_SYSTEM, HttpStatus.FORBIDDEN);
        container.put(UserManagementErrorCode.USER_ALREADY_EXISTS, HttpStatus.CONFLICT);
    }
}

