/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.general.RevertRequestTO;
import de.adorsys.ledgers.middleware.api.domain.oauth.AuthoriseForUserTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserCredentialsTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"LDG007 - User Management (STAFF access)"})
public interface UserMgmtStaffResourceAPI {
    public static final String BASE_PATH = "/staff-access/users";
    public static final String BRANCH = "branch";
    public static final String ROLES = "roles";
    public static final String QUERY_PARAM = "queryParam";
    public static final String BLOCKED = "blockedParam";
    public static final String PAGE = "page";
    public static final String SIZE = "size";
    public static final String USER_ID = "userId";
    public static final String USER_NOT_IN_BRANCH = "User is not your branch";
    public static final String USER_CANNOT_REGISTER_IN_BRANCH = "User cannot register for this branch. The branch is occupied by other user";

    @ApiOperation(tags={"LDG006 - Unprotected Endpoints"}, value="Register", notes="Registers a new user for a given branch.")
    @ApiResponses(value={@ApiResponse(code=200, response=UserTO.class, message="The user data record without the pin."), @ApiResponse(code=409, message="Conflict. A record with the given email or login already exists.")})
    @PostMapping(value={"/register"})
    public ResponseEntity<UserTO> register(@RequestParam(value="branch") String var1, @RequestBody UserTO var2);

    @ApiOperation(tags={"LDG006 - Unprotected Endpoints"}, value="Login fo user")
    @ApiResponses(value={@ApiResponse(code=200, response=UserTO.class, message="The user data record without the pin."), @ApiResponse(code=404, message="User not found.")})
    @PostMapping(value={"/admin/authorize/user"})
    public ResponseEntity<SCALoginResponseTO> authoriseForUser(@RequestBody AuthoriseForUserTO var1);

    @ApiOperation(value="Modify user", notes="Modify existing user within the same branch as creator.", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=UserTO.class, message="Success. Updated user is provided in the response."), @ApiResponse(code=401, message="Wrong authentication credential."), @ApiResponse(code=403, message="Authenticated but user does not have the requested role.")})
    @PostMapping(value={"/modify"})
    public ResponseEntity<UserTO> modifyUser(@RequestParam(value="branch") String var1, @RequestBody UserTO var2);

    @ApiOperation(tags={"LDG006 - Unprotected Endpoints"}, value="Login", notes="Initiates the user login process. Returns a login response object describing how to proceed.")
    @ApiResponses(value={@ApiResponse(code=200, response=SCALoginResponseTO.class, message="Success. LoginToken contained in the returned response object."), @ApiResponse(code=401, message="Wrong authentication credential."), @ApiResponse(code=403, message="Authenticated but user does not have the requested role.")})
    @PostMapping(value={"/login"})
    public ResponseEntity<SCALoginResponseTO> login(@RequestBody UserCredentialsTO var1);

    @ApiOperation(value="Create user", notes="Create new user with the same branch as creator.", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=UserTO.class, message="Success. Created user in provided in the response."), @ApiResponse(code=401, message="Wrong authentication credential."), @ApiResponse(code=403, message="Authenticated but user does not have the requested role.")})
    @PostMapping
    public ResponseEntity<UserTO> createUser(@RequestBody UserTO var1);

    @ApiOperation(value="Lists users by branch and role", notes="Lists users by branch and roles.", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=UserTO.class, message="Success. Created user in provided in the response."), @ApiResponse(code=401, message="Wrong authentication credential."), @ApiResponse(code=403, message="Authenticated but user does not have the requested role.")})
    @GetMapping
    public ResponseEntity<CustomPageImpl<UserTO>> getBranchUsersByRoles(@RequestParam(value="roles") List<UserRoleTO> var1, @RequestParam(value="queryParam", defaultValue="", required=false) String var2, @RequestParam(value="blockedParam", required=false) Boolean var3, @RequestParam(value="page") int var4, @RequestParam(value="size") int var5);

    @ApiOperation(value="Gets user by ID if it's within the branch", notes="Gets user by ID if it's within the branch.", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=UserTO.class, message="Success. Created user in provided in the response."), @ApiResponse(code=401, message="Wrong authentication credential."), @ApiResponse(code=403, message="Authenticated but user does not have the requested role.")})
    @GetMapping(value={"/{userId}"})
    public ResponseEntity<UserTO> getBranchUserById(@PathVariable(value="userId") String var1);

    @ApiOperation(value="Updates SCA Data for user if it's within the branch.", notes="Updates SCA Data for user if it's within the branch.", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=UserTO.class, message="Success. Created user in provided in the response."), @ApiResponse(code=401, message="Wrong authentication credential."), @ApiResponse(code=403, message="Authenticated but user does not have the requested role.")})
    @PostMapping(value={"/{userId}/sca-data"})
    public ResponseEntity<Void> updateUserScaData(@PathVariable(value="userId") String var1, @RequestBody List<ScaUserDataTO> var2);

    @ApiOperation(value="Grants/Updates Account Access for user.", notes="Grants/Updates Account Access for user.", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, message="Success. Account Access Successfully updated."), @ApiResponse(code=401, message="Wrong authentication credential."), @ApiResponse(code=403, message="Authenticated but user does not have the requested role.")})
    @PutMapping(value={"/access/{userId}"})
    public ResponseEntity<Void> updateAccountAccessForUser(@PathVariable(value="userId") String var1, @RequestBody AccountAccessTO var2);

    @ApiOperation(value="Block/Unblock user", notes="Changes block state for given user, returns status being set to the block", authorizations={@Authorization(value="apiKey")})
    @PostMapping(value={"/{userId}/status"})
    public ResponseEntity<Boolean> changeStatus(@PathVariable(value="userId") String var1);

    @PostMapping(value={"/revert"})
    @ApiOperation(value="Reverts DB state for given user to the given date and time.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<Void> revertDatabase(@RequestBody RevertRequestTO var1);
}

