/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"LDG004 - Consent"}, description="Provide an API to manage consent at the core banking level.")
public interface ConsentRestAPI {
    public static final String BASE_PATH = "/consents";

    @PostMapping(value={"/{consentId}/authorisations"})
    @ApiOperation(value="Start SCA", notes="Starts an authorisation process for establishing account information consent data on the server.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<SCAConsentResponseTO> startSCA(@PathVariable(value="consentId") String var1, @RequestBody AisConsentTO var2);

    @GetMapping(value={"/{consentId}/authorisations/{authorisationId}"})
    @ApiOperation(value="Get SCA", notes="Get the authorization response object eventually containing the list of selected sca methods.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<SCAConsentResponseTO> getSCA(@PathVariable(value="consentId") String var1, @PathVariable(value="authorisationId") String var2);

    @PutMapping(value={"/{consentId}/authorisations/{authorisationId}/scaMethods/{scaMethodId}"})
    @ApiOperation(value="Select SCA Method", notes="Select teh given sca method and request for authentication code generation.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<SCAConsentResponseTO> selectMethod(@PathVariable(value="consentId") String var1, @PathVariable(value="authorisationId") String var2, @PathVariable(value="scaMethodId") String var3);

    @PutMapping(value={"/{consentId}/authorisations/{authorisationId}/authCode"})
    @ApiOperation(value="Send an authentication code for validation", notes="Validate an authetication code and returns the cosent token", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<SCAConsentResponseTO> authorizeConsent(@PathVariable(value="consentId") String var1, @PathVariable(value="authorisationId") String var2, @RequestParam(name="authCode") String var3);

    @PostMapping(value={"/piis"})
    @ApiOperation(value="Generate a consent token for CiF", notes="Generate a consent token for CiF. There is no sca process need as we assume the caller is fully authenticated.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<SCAConsentResponseTO> grantPIISConsent(@RequestBody AisConsentTO var1);
}

