/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"LDG999 - Admin Management (SYSTEM access)"})
public interface AdminResourceAPI {
    public static final String BASE_PATH = "/admin";
    public static final String BRANCH_ID = "branchId";
    public static final String USER_ID = "userId";
    public static final String BRANCH_LOGIN = "branchLogin";
    public static final String COUNTRY_CODE = "country";
    public static final String USER_LOGIN = "userLogin";
    public static final String ROLE = "role";
    public static final String BLOCKED = "blocked";
    public static final String IBAN = "ibanParam";
    public static final String PAGE = "page";
    public static final String SIZE = "size";
    public static final String PASSWORD = "password";

    @ApiOperation(value="Get users with filtering", notes="Retrieves Page of Users with multiple filters", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/users"})
    public ResponseEntity<CustomPageImpl<UserExtendedTO>> users(@RequestParam(value="country", defaultValue="", required=false) String var1, @RequestParam(value="branchId", defaultValue="", required=false) String var2, @RequestParam(value="branchLogin", defaultValue="", required=false) String var3, @RequestParam(value="userLogin", defaultValue="", required=false) String var4, @RequestParam(value="role", required=false) UserRoleTO var5, @RequestParam(value="blocked", required=false) Boolean var6, @RequestParam(value="page") int var7, @RequestParam(value="size") int var8);

    @ApiOperation(value="Get users with System role", notes="Retrieves Page of Users with System role", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/admins"})
    public ResponseEntity<CustomPageImpl<UserTO>> admins(@RequestParam(value="page") int var1, @RequestParam(value="size") int var2);

    @ApiOperation(value="Get accounts with filtering", notes="Retrieves Page of Accounts with multiple filters", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/accounts"})
    public ResponseEntity<CustomPageImpl<AccountDetailsExtendedTO>> accounts(@RequestParam(value="country", defaultValue="", required=false) String var1, @RequestParam(value="branchId", defaultValue="", required=false) String var2, @RequestParam(value="branchLogin", defaultValue="", required=false) String var3, @RequestParam(value="ibanParam", required=false, defaultValue="") String var4, @RequestParam(value="blocked", required=false) Boolean var5, @RequestParam(value="page") int var6, @RequestParam(value="size") int var7);

    @ApiOperation(value="Set password for Branch", notes="Changes password for given Branch", authorizations={@Authorization(value="apiKey")})
    @PutMapping(value={"/password"})
    public ResponseEntity<Void> updatePassword(@RequestParam(value="branchId") String var1, @RequestParam(value="password") String var2);

    @ApiOperation(value="Block/Unblock user", notes="Changes system block or regular block state for given user, returns status being set to the block", authorizations={@Authorization(value="apiKey")})
    @PostMapping(value={"/status"})
    public ResponseEntity<Boolean> changeStatus(@RequestParam(value="userId") String var1);

    @ApiOperation(value="Create new User by Admin", notes="Can create STAFF/CUSTOMER/SYSTEM users", authorizations={@Authorization(value="apiKey")})
    @PostMapping(value={"/user"})
    public ResponseEntity<UserTO> register(@RequestBody UserTO var1);

    @ApiOperation(value="Update user", notes="Update user", authorizations={@Authorization(value="apiKey")})
    @PutMapping(value={"/users"})
    public ResponseEntity<Void> user(@RequestBody UserTO var1);
}

