/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.exception;

import de.adorsys.ledgers.util.exception.SCAErrorCode;
import java.util.EnumMap;
import org.springframework.http.HttpStatus;

public class ScaHttpStatusResolver {
    private static final EnumMap<SCAErrorCode, HttpStatus> container = new EnumMap(SCAErrorCode.class);

    private ScaHttpStatusResolver() {
    }

    public static HttpStatus resolveHttpStatusByCode(SCAErrorCode code) {
        return container.get(code);
    }

    static {
        container.put(SCAErrorCode.USER_SCA_DATA_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(SCAErrorCode.SCA_OPERATION_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(SCAErrorCode.AUTH_CODE_GENERATION_FAILURE, HttpStatus.BAD_REQUEST);
        container.put(SCAErrorCode.SCA_OPERATION_VALIDATION_INVALID, HttpStatus.BAD_REQUEST);
        container.put(SCAErrorCode.SCA_OPERATION_USED_OR_STOLEN, HttpStatus.FORBIDDEN);
        container.put(SCAErrorCode.SCA_OPERATION_EXPIRED, HttpStatus.FORBIDDEN);
        container.put(SCAErrorCode.SCA_VALIDATION_ATTEMPT_FAILED, HttpStatus.FORBIDDEN);
        container.put(SCAErrorCode.SCA_OPERATION_FAILED, HttpStatus.FORBIDDEN);
        container.put(SCAErrorCode.PSU_AUTH_ATTEMPT_INVALID, HttpStatus.FORBIDDEN);
        container.put(SCAErrorCode.AUTHENTICATION_FAILURE, HttpStatus.FORBIDDEN);
        container.put(SCAErrorCode.SCA_METHOD_NOT_SUPPORTED, HttpStatus.NOT_IMPLEMENTED);
    }
}

