/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountIdentifierTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.AdditionalAccountInformationTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.time.LocalDate;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"LDG002 - Accounts"}, description="Provides access to a deposit account. This interface does not provide any endpoint to list all accounts.")
public interface AccountRestAPI {
    public static final String BASE_PATH = "/accounts";
    public static final String IBAN_QUERY_PARAM = "iban";
    public static final String LOCAL_DATE_YYYY_MM_DD_FORMAT = "yyyy-MM-dd";
    public static final String DATE_TO_QUERY_PARAM = "dateTo";
    public static final String DATE_FROM_QUERY_PARAM = "dateFrom";
    public static final String ACCOUNT_ID = "accountId";
    public static final String TRANSACTION_ID = "transactionId";
    public static final String PAGE = "page";
    public static final String SIZE = "size";

    @GetMapping
    @ApiOperation(value="List fo Accessible Accounts", authorizations={@Authorization(value="apiKey")}, notes="Returns the list of all accounts linked to the connected user. Call only available to role CUSTOMER.")
    @ApiResponses(value={@ApiResponse(code=200, response=AccountDetailsTO[].class, message="List of accounts accessible to the user.")})
    public ResponseEntity<List<AccountDetailsTO>> getListOfAccounts();

    @PostMapping
    @ApiOperation(value="Registers a new Deposit Account", notes="Registers a new deposit account and assigns account access OWNER to the current user.Following rules apply during and after registration of a new account:<ul><li>Caller must have a role <b>CUSTOMER</b> this means STAFF and SYSTEM can not use this endpoint.</li><li>Caller must have a valid <b>DIRECT_ACCESS</b> token. Means this can not be called using a LOGIN or a DELEGATED_ACCESS (tpp) token.</li><li>The current access token of the user does not include the newly registered account. User must reauthenticate to obtain an updated access token.</li><li>Nevertheless the Endpoint '/accounts' returns all accounts of the user.</li><li>Endpoint for granting account access to another user is scheduled but not yet implemented.</li></ul>", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, message="Account creation successful. Still planing to work with 201 here."), @ApiResponse(code=409, message="Account with given IBAN already exists.")})
    public ResponseEntity<Void> createDepositAccount(@RequestBody AccountDetailsTO var1);

    @GetMapping(value={"/{accountId}"})
    @ApiOperation(value="Load Account by AccountId", notes="Returns account details information for the given account id. User must have access to the target account. This is also accessible to other token types like tpp token (DELEGATED_ACESS)", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=AccountDetailsTO.class, message="Account details.")})
    public ResponseEntity<AccountDetailsTO> getAccountDetailsById(@ApiParam(value="accountId") @PathVariable(name="accountId") String var1);

    @GetMapping(value={"/{accountId}/balances"})
    @ApiOperation(value="Read balances", notes="Returns balances of the deposit account with the given accountId. User must have access to the target account. This is also accessible to other token types like tpp token (DELEGATED_ACESS)", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=AccountBalanceTO[].class, message="List of accounts balances for the given account.")})
    public ResponseEntity<List<AccountBalanceTO>> getBalances(@ApiParam(value="accountId") @PathVariable(name="accountId") String var1);

    @GetMapping(path={"/{accountId}/transactions"}, params={"dateFrom", "dateTo"})
    @ApiOperation(value="Find Transactions By Date", notes="Returns all transactions for the given account id", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<List<TransactionTO>> getTransactionByDates(@ApiParam(value="accountId") @PathVariable(name="accountId") String var1, @RequestParam(name="dateFrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate var2, @RequestParam(name="dateTo") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate var3);

    @GetMapping(path={"/{accountId}/transactions/page"}, params={"dateFrom", "dateTo", "page", "size"})
    @ApiOperation(value="Find Transactions By Date", notes="Returns transactions for the given account id for certain dates, paged view", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<CustomPageImpl<TransactionTO>> getTransactionByDatesPaged(@ApiParam(value="accountId") @PathVariable(name="accountId") String var1, @RequestParam(name="dateFrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate var2, @RequestParam(name="dateTo") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate var3, @RequestParam(value="page") int var4, @RequestParam(value="size") int var5);

    @GetMapping(value={"/{accountId}/transactions/{transactionId}"})
    @ApiOperation(value="Load Transaction", notes="Returns the transaction with the given account id and transaction id.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<TransactionTO> getTransactionById(@ApiParam(value="accountId") @PathVariable(name="accountId") String var1, @ApiParam(value="transactionId") @PathVariable(name="transactionId") String var2);

    @GetMapping(path={"/query"}, params={"iban"})
    @ApiOperation(value="Load Account Details By IBAN", authorizations={@Authorization(value="apiKey")}, notes="Returns account details information given the account IBAN")
    public ResponseEntity<AccountDetailsTO> getAccountDetailsByIban(@ApiParam(value="The IBAN of the requested account: e.g.: DE69760700240340283600", example="DE69760700240340283600") @RequestParam(name="iban") String var1);

    @ApiOperation(value="Fund Confirmation", authorizations={@Authorization(value="apiKey")}, notes="Returns account details information given the account IBAN")
    @PostMapping(value={"/funds-confirmation"})
    public ResponseEntity<Boolean> fundsConfirmation(@RequestBody FundsConfirmationRequestTO var1);

    @PostMapping(value={"/{accountId}/cash"})
    @ApiOperation(value="Deposit Cash", authorizations={@Authorization(value="apiKey")}, notes="Only technical users are authorized to perform this operation")
    public ResponseEntity<Void> depositCash(@PathVariable(name="accountId") String var1, @RequestBody AmountTO var2);

    @GetMapping(path={"/info/{accountIdentifierType}/{accountIdentifier}"})
    @ApiOperation(value="Load Account Owner Additional information", authorizations={@Authorization(value="apiKey")}, notes="Returns Additional Account Information by Account Identifier")
    public ResponseEntity<List<AdditionalAccountInformationTO>> getAdditionalAccountInfo(@ApiParam(value="Account identifier type i.e. ACCOUNT_ID / IBAN") @PathVariable(name="accountIdentifierType") AccountIdentifierTypeTO var1, @ApiParam(value="The IBAN of the requested account: e.g.: DE69760700240340283600", example="DE69760700240340283600") @PathVariable(name="accountIdentifier") String var2);
}

