/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.general.BbanStructure;
import de.adorsys.ledgers.middleware.api.domain.general.RecoveryPointTO;
import de.adorsys.ledgers.middleware.api.domain.um.UploadedDataTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.Currency;
import java.util.List;
import java.util.Set;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags={"LDG012 - Data management (STAFF access)"})
public interface DataMgmtStaffAPI {
    public static final String BASE_PATH = "/staff-access/data";

    @DeleteMapping(value={"/transactions/{accountId}"})
    @ApiOperation(value="Removes all transactions for account", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<Void> account(@PathVariable(value="accountId") String var1);

    @DeleteMapping(value={"/account/{accountId}"})
    @ApiOperation(value="Removes account", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<Void> depositAccount(@PathVariable(value="accountId") String var1);

    @DeleteMapping(value={"/user/{userId}"})
    @ApiOperation(value="Removes user", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<Void> user(@PathVariable(value="userId") String var1);

    @DeleteMapping(value={"/branch/{branchId}"})
    @ApiOperation(value="Removes all data related to TPP", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<Void> branch(@PathVariable(value="branchId") String var1);

    @ApiOperation(value="Upload data to Ledgers (users, accounts, transactions, balances)", authorizations={@Authorization(value="apiKey")})
    @PostMapping(value={"/upload"})
    public ResponseEntity<Void> uploadData(@RequestBody UploadedDataTO var1);

    @ApiOperation(value="Retrieve the currencies list supported by ASPSP", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/currencies"})
    public ResponseEntity<Set<Currency>> currencies();

    @ApiOperation(value="Get next free branch id for country")
    @PostMapping(value={"/branch"})
    public ResponseEntity<String> branchId(@RequestBody BbanStructure var1);

    @ApiOperation(value="Create Recovery point", authorizations={@Authorization(value="apiKey")})
    @PostMapping(value={"/point"})
    public ResponseEntity<Void> createPoint(@RequestBody RecoveryPointTO var1);

    @ApiOperation(value="Get all Recovery points related to current branch", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/point/all"})
    public ResponseEntity<List<RecoveryPointTO>> getAllPoints();

    @ApiOperation(value="Get Recovery point by id related to current branch", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/point/{id}"})
    public ResponseEntity<RecoveryPointTO> getPoint(@PathVariable(value="id") Long var1);

    @ApiOperation(value="Deletes Recovery point by id related to current branch", authorizations={@Authorization(value="apiKey")})
    @DeleteMapping(value={"/point/{id}"})
    public ResponseEntity<Void> deletePoint(@PathVariable(value="id") Long var1);
}

