/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaLoginOprTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"LDG007 - Redirect SCA"}, description="Provide an API to preform SCA process for any kind of banking operation")
public interface RedirectScaRestAPI {
    public static final String BASE_PATH = "/sca";

    @PostMapping(value={"/login"})
    @ApiOperation(tags={"LDG015 - Unprotected Endpoints"}, value="Login For Consent")
    public ResponseEntity<GlobalScaResponseTO> authoriseForConsent(@RequestBody ScaLoginOprTO var1);

    @GetMapping(value={"/authorisations/{authorisationId}"})
    @ApiOperation(value="Get SCA", notes="Get the authorization response object eventually containing the list of selected sca methods.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<GlobalScaResponseTO> getSCA(@PathVariable(value="authorisationId") String var1);

    @PutMapping(value={"/authorisations/{authorisationId}/scaMethods/{scaMethodId}"})
    @ApiOperation(value="Select SCA Method", notes="Select teh given sca method and request for authentication code generation.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<GlobalScaResponseTO> selectMethod(@PathVariable(value="authorisationId") String var1, @PathVariable(value="scaMethodId") String var2);

    @PutMapping(value={"/authorisations/{authorisationId}/authCode"})
    @ApiOperation(value="Validate authorization code", notes="Validate an authentication code and returns the token", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<GlobalScaResponseTO> authorize(@PathVariable(value="authorisationId") String var1, @RequestParam(name="authCode") String var2);
}

