/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.oauth.GrantTypeTO;
import de.adorsys.ledgers.middleware.api.domain.oauth.OauthCodeResponseTO;
import de.adorsys.ledgers.middleware.api.domain.oauth.OauthServerInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"LDG06 - Oauth authorisation"})
public interface OauthRestApi {
    public static final String BASE_PATH = "/oauth";

    @PostMapping(value={"/authorise"})
    @ApiOperation(value="Get authorisation code")
    public ResponseEntity<OauthCodeResponseTO> oauthCode(@RequestParam(value="login") String var1, @RequestParam(value="pin") String var2, @RequestParam(value="redirect_uri") String var3);

    @PostMapping(value={"/authorise/oauth"})
    @ApiOperation(value="Get authorisation code, with token", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<OauthCodeResponseTO> oauthCode(@RequestParam(value="redirect_uri") String var1);

    @PostMapping(value={"/token"})
    @ApiOperation(value="Get/refresh access token")
    public ResponseEntity<BearerTokenTO> oauthToken(@RequestParam(value="grant_type") GrantTypeTO var1, @RequestParam(value="code") String var2);

    @GetMapping(value={"/authorization-server"})
    @ApiOperation(value="Authorization server metadata request")
    public ResponseEntity<OauthServerInfoTO> oauthServerInfo();
}

