/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"LDG013 - Email verification"}, description="Provides endpoint for sending mail with verification link and email confirmation.")
public interface ScaVerificationRestAPI {
    public static final String BASE_PATH = "/emails";

    @PostMapping(value={"/email-verification"})
    @ApiOperation(value="Send email for verification", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, message="Email was successfully send."), @ApiResponse(code=404, message="Error sending email: verification token or sca data not found.")})
    public ResponseEntity<Void> sendEmailVerification(@RequestParam(value="email") String var1);

    @GetMapping(value={"/email"})
    @ApiOperation(tags={"LDG006 - Unprotected Endpoints"}, value="Confirm email")
    @ApiResponses(value={@ApiResponse(code=200, message="Email was successfully confirm."), @ApiResponse(code=400, message="Invalid verification token for email confirmation or email already confirm."), @ApiResponse(code=403, message="Verification token is expired for email confirmation."), @ApiResponse(code=404, message="Error confirmation email: sca data not found.")})
    public ResponseEntity<Void> confirmVerificationToken(@RequestParam(value="verificationToken") String var1);
}

