/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTypeTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"LDG001 - User Management"}, description="Provides endpoint for registering, authorizing and managing users.")
public interface UserMgmtRestAPI {
    public static final String BASE_PATH = "/users";

    @GetMapping(value={"/multilevel"})
    @ApiOperation(tags={"LDG006 - Unprotected Endpoints"}, value="Check if multilevel SCA required for certain user")
    @ApiResponses(value={@ApiResponse(code=200, response=boolean.class, message="Boolean representation of requirement for multi-level sca")})
    public ResponseEntity<Boolean> multilevel(@RequestParam(value="login") String var1, @RequestParam(value="iban") String var2);

    @PostMapping(value={"/multilevel"})
    @ApiOperation(tags={"LDG006 - Unprotected Endpoints"}, value="Check if multilevel SCA required for certain user")
    @ApiResponses(value={@ApiResponse(code=200, response=boolean.class, message="Boolean representation of requirement for multi-level sca")})
    public ResponseEntity<Boolean> multilevelAccounts(@RequestParam(value="login") String var1, @RequestBody List<AccountReferenceTO> var2);

    @PostMapping(value={"/register"})
    @ApiOperation(tags={"LDG006 - Unprotected Endpoints"}, value="Register", notes="Registers a user.<ul><li>A user is always registered as customer and is activated by default.</li><li>A user can only be given another role by an administrating STAFF member.</li><li>Choose type 'FAKE' if you don't want to receive any messages.</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, response=UserTO.class, message="The user data record without the user pin."), @ApiResponse(code=409, message="Conflict. A user with email or login name already exist.")})
    public ResponseEntity<UserTO> register(@RequestParam(value="login") String var1, @RequestParam(value="email") String var2, @RequestParam(value="pin") String var3, @RequestParam(name="role", defaultValue="CUSTOMER") UserRoleTO var4, @RequestParam(value="type", defaultValue="FAKE") UserTypeTO var5);

    @PostMapping(value={"/login"})
    @ApiOperation(tags={"LDG006 - Unprotected Endpoints"}, value="Login", notes="Initiates the user login process. Returns a login response object describing how to proceed. This response object contains both an scaId and an authorizationId that must be used to identify this login process.<br/>This response also contains an scaStatus that indicates the next stept to take.<ul><li>EXEMPTED: the response will contain the final bearer token.<ul><li>The login process is complete in this single step.</li><li>The response contains a full JWT access token that can be used to access account and payment endpoints.</li>/ul></li><li>SCAMETHODSELECTED: the auth code has been directly sent to the user because the user has only one sca method configured for login. <ul><li>Auth code Must be entered by the user.</li><li>Response contains a JWT token that must be used to authenticate for further action. This token can not be used to perform account access because the authentication process is not completed.<li><li>Caller must proceed with the authCode endpoint: /{scaId}/authorisations/{authorisationId}/authCode</li></ul></li><li>PSUAUTHENTICATED: the user has many sca methods configured for login.<ul><li>The response contains a list of scaMethods for selection</li>. <li>Response contains a JWT token that must be used to authenticate for further calls.</li><li>This token can not be used to perform account access because the authentication process is not completed.</li><li>Caller must proceed with the authCode endpoint: /{scaId}/authorisations/{authorisationId}/scaMethods/{scaMethodId}</li></ul></li><li>PSUIDENTIFIED: the user exists but given password/pin did not match.</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, response=SCALoginResponseTO.class, message="Success. LoginToken contained in the returned response object."), @ApiResponse(code=401, message="Wrong authentication credential."), @ApiResponse(code=403, message="Authenticated but user does not have the requested role.")})
    public ResponseEntity<SCALoginResponseTO> authorise(@RequestParam(value="login") String var1, @RequestParam(value="pin") String var2, @RequestParam(value="role") UserRoleTO var3);

    @PostMapping(value={"/loginForConsent"})
    @ApiOperation(tags={"LDG006 - Unprotected Endpoints"}, value="Login For Consent", notes="Initiates the user login process for a payment or account information process. Returns a login response object describing how to proceed. This response object contains both an paymentId (consentId) and an authorizationId that must be used to identify this corresponding process.<br/>This response also contains an scaStatus that indicates the next stept to take.<ul><li>EXEMPTED: the operation to execute is exempted from sca. The operation can be complete in this single step. </li><li>PSUAUTHENTICATED: the user has one or many sca methods configured for the operation.<ul><li>The response contains a list of scaMethods for selection</li>. <li>Response contains a JWT token that must be used to authenticate for further calls.</li><li>This token can not be used to perform account access because the authentication process is not completed.</li><li>Caller must proceed with the sca selection</li></ul></li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, response=SCALoginResponseTO.class, message="Success. LoginToken contained in the returned response object."), @ApiResponse(code=401, message="Wrong authentication credential."), @ApiResponse(code=403, message="Authenticated but user does not have the requested role.")})
    public ResponseEntity<SCALoginResponseTO> authoriseForConsent(@RequestParam(value="login") String var1, @RequestParam(value="pin") String var2, @RequestParam(value="consentId") String var3, @RequestParam(value="authorisationId") String var4, @RequestParam(value="opType") OpTypeTO var5);

    @PostMapping(value={"/loginForConsent/oauth"})
    @ApiOperation(value="Login for consent operation with bearer token", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=SCALoginResponseTO.class, message="Success. LoginToken contained in the returned response object."), @ApiResponse(code=401, message="Wrong authentication credential."), @ApiResponse(code=403, message="Authenticated but user does not have the requested role.")})
    public ResponseEntity<SCALoginResponseTO> authoriseForConsent(@RequestParam(value="consentId") String var1, @RequestParam(value="authorisationId") String var2, @RequestParam(value="opType") OpTypeTO var3);

    @PostMapping(value={"/validate"})
    @ApiOperation(tags={"LDG006 - Unprotected Endpoints"}, value="Introspect Token", nickname="IntrospectToken", notes="Validates a JWT access token and make sure permissions contained in this token are still in synch with the state of permission associated with the underlying user.<ul><li>This endpoint can optionaly be used by a presentation layer to revalidate a long living token like an AIS Consent token that can last up to 90 days.</li><li>Response is an introspected access token object that can associated with the user request in the server.</ul>")
    public ResponseEntity<BearerTokenTO> validate(@RequestParam(value="accessToken") String var1);

    @PutMapping(value={"/{scaId}/authorisations/{authorisationId}/scaMethods/{scaMethodId}"})
    @ApiOperation(value="Select Sca Method", notes="Selects the scaMethod to use for sending a an auth code to the user. <ul><li>This endpoint is only valid for the login (can not be used for payment or account access).</li><li>The call requires a JWT login token with matching scaId and authorisationId.</li><li>The result of a sucessfull execution must be an SCALoginResponseTO object containing an scaStatus SCAMETHODSELECTED, indicating that an auth code has been generated and sent to the user.</li><li>Caller must proceed with the authCode endpoint: /{scaId}/authorisations/{authorisationId}/authCode</li></ul>", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=SCALoginResponseTO.class, message="Authentication Code generated and sent through the selected method"), @ApiResponse(code=422, message="Wrong authorization code"), @ApiResponse(code=406, message="The given methodId is not supported for login process. This shall not happen as the preceeding call returns the list of method to select from."), @ApiResponse(code=404, message="Either the authorization instance is not found or the given scaMethodId does not exist."), @ApiResponse(code=403, message="Auth code consumed but user does not have the required role."), @ApiResponse(code=401, message="Provided bearer token could not be verified.")})
    public ResponseEntity<SCALoginResponseTO> selectMethod(@ApiParam(name="scaId", value="The identifier of this login process. Contained in the SCALoginResponseTO received from the preceeding call.") @PathVariable(name="scaId") String var1, @ApiParam(name="authorisationId", value="The identifier of the authorisation instance of this login process. Generally identical to the scaId. But might differ if a login requires many authorizations. Contained in the SCALoginResponseTO received from the preceeding call.") @PathVariable(value="authorisationId") String var2, @ApiParam(name="scaMethodId", value="methodId selected from the list of scaMethods contained in the SCALoginResponseTO received from the preceeding call.") @PathVariable(value="scaMethodId") String var3);

    @PutMapping(value={"/{scaId}/authorisations/{authorisationId}/authCode"})
    @ApiOperation(value="Authorize Login", notes="Sends the auth code for two factor login. The returned response contains a bearer token that can be used to authenticate further operations.<ul><li>This endpoint is only valid for the login (can not be used for payment or account access).</li><li>The call requires a JWT login token with matching scaId and authorisationId.</li><li>The result of a sucessfull execution must be an SCALoginResponseTO object containing an scaStatus SCAMETHODSELECTED, indicating that an auth code has been generated and sent to the user.</li><li>Caller must proceed with the authCode endpoint: /{scaId}/authorisations/{authorisationId}/authCode</li></ul>", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=SCALoginResponseTO.class, message="Authentication complete. Returned access token can be used for further operations."), @ApiResponse(code=410, message="The provided authorization id is already consumed. Restart authentication."), @ApiResponse(code=404, message="Either the authorization instance is not found or the given scaMethodId does not exist."), @ApiResponse(code=422, message="The provided authorization code is wrong."), @ApiResponse(code=406, message="The given methodId is not supported for login process. This shall not happen as the preceeding call returns the list of method to select from."), @ApiResponse(code=403, message="Auth code consumed but user does not have the required role."), @ApiResponse(code=401, message="Provided bearer token could not be verified.")})
    public ResponseEntity<SCALoginResponseTO> authorizeLogin(@PathVariable(value="scaId") String var1, @PathVariable(value="authorisationId") String var2, @RequestParam(name="authCode") String var3);

    @GetMapping(value={"/me"})
    @ApiOperation(value="Current User", notes="Retrieves the current usder.<ul><li>The idetifying information (userId=accessToken.sub) is implied from the security context information</li><li>Will send back a 500 if the token is valid and the user is not found. This rather means that the user has been deleted since producing this token in a preceeding step might have implied the existence of the user.</li></ul>", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=UserTO.class, message="The user data record without the user pin."), @ApiResponse(code=401, message="Provided bearer token could not be verified.")})
    public ResponseEntity<UserTO> getUser();

    @PutMapping(value={"/sca-data"})
    @ApiOperation(value="Updates user SCA", notes="Updates user authentication methods.<lu><li>User is implied from the provided access token.</li><li>Actor token (delegation token like ais cosent token) can not be used to execute this operation</li></ul>", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=Void.class, message="The user data record without the user pin."), @ApiResponse(code=401, message="Provided bearer token could not be verified."), @ApiResponse(code=403, message="Provided bearer token not qualified for this operation.")})
    public ResponseEntity<Void> updateUserScaData(@RequestBody List<ScaUserDataTO> var1);

    @GetMapping(value={"/{userId}"})
    @ApiOperation(value="Retrieves User by ID", notes="Retrieves User by ID<lu><li>This can only be called by either SYSTEM or STAFF members.</li><li>Will be moved to a management interface in the future.</li></lu>", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<UserTO> getUserById(@PathVariable(value="userId") String var1);

    @GetMapping
    @ApiOperation(value="Lists users collection", notes="Lists users collection.<lu><li>This can only be called by either SYSTEM or STAFF members.</li><li>Will be changed to include pagination and moved to a management interface in the future.</li></lu>", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<List<UserTO>> getAllUsers();
}

