/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.um.UploadedDataTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Currency;
import java.util.Set;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags={"LDG011 - Data management (STAFF access)"})
public interface DataMgmtStaffAPI {
    public static final String BASE_PATH = "/staff-access/data";

    @DeleteMapping(value={"/transactions/{iban}"})
    @ApiOperation(value="Removes all transactions for account", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, message="The user data record without the user pin."), @ApiResponse(code=401, message="Provided bearer token could not be verified."), @ApiResponse(code=403, message="Provided bearer token not qualified for this operation."), @ApiResponse(code=404, message="Account not found.")})
    public ResponseEntity<Void> account(@PathVariable(value="iban") String var1);

    @DeleteMapping(value={"/branch/{branchId}"})
    @ApiOperation(value="Removes all data related to TPP", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, message="The user data record without the user pin."), @ApiResponse(code=401, message="Provided bearer token could not be verified."), @ApiResponse(code=403, message="Provided bearer token not qualified for this operation."), @ApiResponse(code=404, message="Tpp not found.")})
    public ResponseEntity<Void> branch(@PathVariable(value="branchId") String var1);

    @ApiOperation(value="Upload data to Ledgers (users, accounts, transactions, balances)", authorizations={@Authorization(value="apiKey")})
    @PostMapping(value={"/upload"})
    public ResponseEntity<Void> uploadData(@RequestBody UploadedDataTO var1);

    @ApiOperation(value="Retrieve the currencies list supported by ASPSP", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/currencies"})
    public ResponseEntity<Set<Currency>> currencies();
}

