/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.exception;

import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import java.util.EnumMap;
import org.springframework.http.HttpStatus;

public class MiddlewareHttpStatusResolver {
    private static final EnumMap<MiddlewareErrorCode, HttpStatus> container = new EnumMap(MiddlewareErrorCode.class);

    private MiddlewareHttpStatusResolver() {
    }

    public static HttpStatus resolveHttpStatusByCode(MiddlewareErrorCode code) {
        return container.get(code);
    }

    static {
        container.put(MiddlewareErrorCode.CURRENCY_MISMATCH, HttpStatus.BAD_REQUEST);
        container.put(MiddlewareErrorCode.PAYMENT_PROCESSING_FAILURE, HttpStatus.BAD_REQUEST);
        container.put(MiddlewareErrorCode.ACCOUNT_CREATION_VALIDATION_FAILURE, HttpStatus.BAD_REQUEST);
        container.put(MiddlewareErrorCode.REQUEST_VALIDATION_FAILURE, HttpStatus.BAD_REQUEST);
        container.put(MiddlewareErrorCode.CAN_NOT_RESOLVE_SCA_CHALLENGE_DATA, HttpStatus.BAD_REQUEST);
        container.put(MiddlewareErrorCode.ACCOUNT_DISABLED, HttpStatus.BAD_REQUEST);
        container.put(MiddlewareErrorCode.AUTHENTICATION_FAILURE, HttpStatus.FORBIDDEN);
        container.put(MiddlewareErrorCode.INSUFFICIENT_PERMISSION, HttpStatus.FORBIDDEN);
        container.put(MiddlewareErrorCode.BRANCH_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(MiddlewareErrorCode.NO_SUCH_ALGORITHM, HttpStatus.BAD_REQUEST);
    }
}

