/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"LDG003 - Payment"}, description="Provide endpoint for initiating and executing payment.")
public interface PaymentRestAPI {
    public static final String BASE_PATH = "/payments";

    @GetMapping(value={"/{paymentId}/status"})
    @ApiOperation(value="Read Payment Status", notes="Returns the status of a payment", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<TransactionStatusTO> getPaymentStatusById(@PathVariable(value="paymentId") String var1);

    @GetMapping(value={"/{paymentId}"})
    @ApiOperation(value="Load Payment", notes="Returns the payment", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<?> getPaymentById(@PathVariable(name="paymentId") String var1);

    @PostMapping(params={"paymentType"})
    @ApiOperation(value="Initiates a Payment", notes="Initiates a payment", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=SCAPaymentResponseTO.class, message="Success. ScaToken contained in the returned response object."), @ApiResponse(code=404, message="Specified account not found."), @ApiResponse(code=403, message="Not authorized to execute payment on this account"), @ApiResponse(code=409, message="Payment with specified paymentId exists. Either leaved it blank or generate a new one.")})
    public ResponseEntity<SCAPaymentResponseTO> initiatePayment(@RequestParam(value="paymentType") PaymentTypeTO var1, @RequestBody Object var2);

    @PostMapping(value={"/pain"}, params={"paymentType"}, consumes={"application/xml"}, produces={"application/xml"})
    @ApiOperation(value="Initiates a pain Payment", notes="Initiates a pain payment", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=String.class, message="Success"), @ApiResponse(code=404, message="Specified account not found."), @ApiResponse(code=403, message="Not authorized to execute payment on this account"), @ApiResponse(code=409, message="Payment with specified paymentId exists. Either leaved it blank or generate a new one.")})
    public ResponseEntity<String> initiatePainPayment(@RequestParam(value="paymentType") PaymentTypeTO var1, @RequestBody String var2);

    @GetMapping(value={"/{paymentId}/authorisations/{authorisationId}"})
    @ApiOperation(value="Get SCA", notes="Get the authorization response object eventually containing the list of selected sca methods.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<SCAPaymentResponseTO> getSCA(@PathVariable(value="paymentId") String var1, @PathVariable(value="authorisationId") String var2);

    @PutMapping(value={"/{paymentId}/authorisations/{authorisationId}/scaMethods/{scaMethodId}"})
    @ApiOperation(value="Select SCA Method", notes="Select teh given sca method and request for authentication code generation.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<SCAPaymentResponseTO> selectMethod(@PathVariable(value="paymentId") String var1, @PathVariable(value="authorisationId") String var2, @PathVariable(value="scaMethodId") String var3);

    @PutMapping(value={"/{paymentId}/authorisations/{authorisationId}/authCode"})
    @ApiOperation(value="Send an authentication code for validation", notes="Validate an authetication code and returns the cosent token", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<SCAPaymentResponseTO> authorizePayment(@PathVariable(value="paymentId") String var1, @PathVariable(value="authorisationId") String var2, @RequestParam(name="authCode") String var3);

    @PostMapping(value={"/{paymentId}/cancellation-authorisations"})
    @ApiOperation(value="Initiates a Payment Cancelation", notes="Initiates a Payment Cancelation", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<SCAPaymentResponseTO> initiatePmtCancellation(@PathVariable(value="paymentId") String var1);

    @GetMapping(value={"/{paymentId}/cancellation-authorisations/{cancellationId}"})
    @ApiOperation(value="Get SCA", notes="Get the authorization response object eventually containing the list of selected sca methods.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<SCAPaymentResponseTO> getCancelSCA(@PathVariable(value="paymentId") String var1, @PathVariable(value="cancellationId") String var2);

    @PutMapping(value={"/{paymentId}/cancellation-authorisations/{cancellationId}/scaMethods/{scaMethodId}"})
    @ApiOperation(value="Select SCA Method", notes="Select teh given sca method and request for authentication code generation.", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<SCAPaymentResponseTO> selecCancelPaymentSCAtMethod(@PathVariable(value="paymentId") String var1, @PathVariable(value="cancellationId") String var2, @PathVariable(value="scaMethodId") String var3);

    @PutMapping(value={"/{paymentId}/cancellation-authorisations/{cancellationId}/authCode"})
    @ApiOperation(value="Send an authentication code for validation", notes="Validate an authetication code and returns the cosent token", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<SCAPaymentResponseTO> authorizeCancelPayment(@PathVariable(value="paymentId") String var1, @PathVariable(value="cancellationId") String var2, @RequestParam(name="authCode") String var3);
}

