/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.exception;

import de.adorsys.ledgers.deposit.api.exception.DepositErrorCode;
import java.util.EnumMap;
import org.springframework.http.HttpStatus;

public class DepositHttpStatusResolver {
    private static final EnumMap<DepositErrorCode, HttpStatus> container = new EnumMap(DepositErrorCode.class);

    private DepositHttpStatusResolver() {
    }

    public static HttpStatus resolveHttpStatusByCode(DepositErrorCode code) {
        return container.get(code);
    }

    static {
        container.put(DepositErrorCode.DEPOSIT_ACCOUNT_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(DepositErrorCode.PAYMENT_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(DepositErrorCode.TRANSACTION_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(DepositErrorCode.INSUFFICIENT_FUNDS, HttpStatus.BAD_REQUEST);
        container.put(DepositErrorCode.DEPOSIT_ACCOUNT_EXISTS, HttpStatus.BAD_REQUEST);
        container.put(DepositErrorCode.PAYMENT_PROCESSING_FAILURE, HttpStatus.BAD_REQUEST);
        container.put(DepositErrorCode.PAYMENT_WITH_ID_EXISTS, HttpStatus.BAD_REQUEST);
        container.put(DepositErrorCode.DEPOSIT_OPERATION_FAILURE, HttpStatus.BAD_REQUEST);
        container.put(DepositErrorCode.ACCOUNT_BLOCKED_DELETED, HttpStatus.BAD_REQUEST);
    }
}

