/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.exception;

import de.adorsys.ledgers.postings.api.exception.PostingErrorCode;
import java.util.EnumMap;
import org.springframework.http.HttpStatus;

public class PostingHttpStatusResolver {
    private static final EnumMap<PostingErrorCode, HttpStatus> container = new EnumMap(PostingErrorCode.class);

    private PostingHttpStatusResolver() {
    }

    public static HttpStatus resolveHttpStatusByCode(PostingErrorCode code) {
        return container.get(code);
    }

    static {
        container.put(PostingErrorCode.LEDGER_ACCOUNT_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(PostingErrorCode.LEDGER_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(PostingErrorCode.POSTING_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(PostingErrorCode.CHART_OF_ACCOUNT_NOT_FOUND, HttpStatus.NOT_FOUND);
        container.put(PostingErrorCode.DOBLE_ENTRY_ERROR, HttpStatus.BAD_REQUEST);
        container.put(PostingErrorCode.BASE_LINE_TIME_ERROR, HttpStatus.BAD_REQUEST);
        container.put(PostingErrorCode.POSTING_TIME_MISSING, HttpStatus.BAD_REQUEST);
        container.put(PostingErrorCode.NOT_ENOUGH_INFO, HttpStatus.BAD_REQUEST);
        container.put(PostingErrorCode.NO_CATEGORY, HttpStatus.BAD_REQUEST);
    }
}

