/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"LDG008 - Accounts (STAFF access)"}, description="Provides access to the deposit account resource for staff members.")
public interface AccountMgmStaffResourceAPI {
    public static final String BASE_PATH = "/staff-access/accounts";
    public static final String ACCOUNT_ID = "accountId";
    public static final String USER_ID = "userId";

    @ApiOperation(value="Registers a new Deposit Account for a user with specified ID", notes="Registers a new deposit account and assigns account access OWNER to the current user.", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, message="Account creation successful"), @ApiResponse(code=404, message="User with this ID not found"), @ApiResponse(code=409, message="Account with given IBAN already exists.")})
    @PostMapping
    public ResponseEntity<Void> createDepositAccountForUser(@RequestParam(name="userId") String var1, @RequestBody AccountDetailsTO var2);

    @ApiOperation(value="List fo Accessible Accounts", authorizations={@Authorization(value="apiKey")}, notes="Returns the list of all accounts linked to the connected user. Call only available to role CUSTOMER.")
    @ApiResponses(value={@ApiResponse(code=200, response=AccountDetailsTO[].class, message="List of accounts accessible to the user.")})
    @GetMapping
    public ResponseEntity<List<AccountDetailsTO>> getListOfAccounts();

    @ApiOperation(value="Load Account by AccountId", notes="Returns account details information for the given account id. User must have access to the target account. This is also accessible to other token types like tpp token (DELEGATED_ACESS)", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=AccountDetailsTO.class, message="Account details.")})
    @GetMapping(value={"/{accountId}"})
    public ResponseEntity<AccountDetailsTO> getAccountDetailsById(@ApiParam(value="accountId") @PathVariable(value="accountId") String var1);

    @ApiOperation(value="Deposit Cash", authorizations={@Authorization(value="apiKey")}, notes="Operation for staff member to register cash in the deposit account")
    @ApiResponses(value={@ApiResponse(code=202, message="Operation was successful")})
    @PostMapping(value={"/{accountId}/cash"})
    public ResponseEntity<Void> depositCash(@PathVariable(value="accountId") String var1, @RequestBody AmountTO var2);
}

