/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.exception;

import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.exception.InsufficientFundsMiddlewareException;
import de.adorsys.ledgers.middleware.rest.exception.PostingHttpStatusResolver;
import de.adorsys.ledgers.middleware.rest.exception.RestException;
import de.adorsys.ledgers.postings.api.exception.PostingModuleException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ExceptionAdvisor {
    private static final String MESSAGE = "message";
    private static final String DEV_MESSAGE = "devMessage";
    private static final String CODE = "code";
    private static final String DATE_TIME = "dateTime";

    @ExceptionHandler(value={InsufficientFundsMiddlewareException.class})
    public ResponseEntity<SCAPaymentResponseTO> handleInsufficientFundsException(InsufficientFundsMiddlewareException e) {
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        response.setTransactionStatus(TransactionStatusTO.RJCT);
        response.setPsuMessage(e.getMessage());
        return ResponseEntity.ok((Object)response);
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    public ResponseEntity handleUnsupportedOperationException(UnsupportedOperationException e) {
        return ResponseEntity.status((int)501).body((Object)e.getMessage());
    }

    @ExceptionHandler(value={RestException.class})
    public ResponseEntity<Map> handleRestException(RestException ex) {
        Map<String, String> body = this.getHandlerContent(ex.getCode(), ex.getMessage(), ex.devMessage);
        return new ResponseEntity(body, ex.getStatus());
    }

    @ExceptionHandler(value={PostingModuleException.class})
    public ResponseEntity<Map> handlePostingModuleException(PostingModuleException ex) {
        HttpStatus status = PostingHttpStatusResolver.resolveHttpStatusByCode(ex.getErrorCode());
        Map<String, String> body = this.getHandlerContent(status, null, ex.getDevMsg());
        return new ResponseEntity(body, status);
    }

    private Map<String, String> getHandlerContent(HttpStatus status, String message, String devMessage) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put(CODE, String.valueOf(status.value()));
        error.put(MESSAGE, message);
        error.put(DEV_MESSAGE, devMessage);
        error.put(DATE_TIME, LocalDateTime.now().toString());
        return error;
    }

    private Map<String, String> getHandlerContent(String code, String message, String devMessage) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put(CODE, code);
        error.put(MESSAGE, message);
        error.put(DEV_MESSAGE, devMessage);
        error.put(DATE_TIME, LocalDateTime.now().toString());
        return error;
    }
}

