/*
 * Copyright 2018-2018 adorsys GmbH & Co KG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.adorsys.ledgers.middleware.rest.exception;

import org.springframework.http.HttpStatus;

public class BadRequestRestException extends RestException {

    public static final String ERROR_CODE = "400_BadRequestRestException";

    private void initialize() {
        withCode(ERROR_CODE);
        withStatus(HttpStatus.BAD_REQUEST);
    }

    public BadRequestRestException(String message) {
        super(message);
        initialize();
    }
    
    public BadRequestRestException() {
        initialize();
    }
}
