/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.mappers;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.postings.api.domain.PostingLineBO;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.stereotype.Component;

@Component
public class TransactionDetailsMapper {
    private final ObjectMapper objectMapper;

    public TransactionDetailsBO toTransactionSigned(PostingLineBO pl) {
        TransactionDetailsBO transaction = this.toTransaction(pl);
        if (BigDecimal.ZERO.compareTo(pl.getCreditAmount()) == 0) {
            AmountBO transactionAmount = transaction.getTransactionAmount();
            transactionAmount.setAmount(transactionAmount.getAmount().negate());
            transaction.setCreditorId(null);
            this.reverse(arg_0 -> ((TransactionDetailsBO)transaction).setCreditorAccount(arg_0), arg_0 -> ((TransactionDetailsBO)transaction).setDebtorAccount(arg_0), () -> ((TransactionDetailsBO)transaction).getCreditorAccount(), () -> ((TransactionDetailsBO)transaction).getDebtorAccount());
            this.reverse(arg_0 -> ((TransactionDetailsBO)transaction).setCreditorAgent(arg_0), arg_0 -> ((TransactionDetailsBO)transaction).setDebtorAgent(arg_0), () -> ((TransactionDetailsBO)transaction).getCreditorAgent(), () -> ((TransactionDetailsBO)transaction).getDebtorAgent());
            this.reverse(arg_0 -> ((TransactionDetailsBO)transaction).setCreditorName(arg_0), arg_0 -> ((TransactionDetailsBO)transaction).setDebtorName(arg_0), () -> ((TransactionDetailsBO)transaction).getCreditorName(), () -> ((TransactionDetailsBO)transaction).getDebtorName());
            this.reverse(arg_0 -> ((TransactionDetailsBO)transaction).setUltimateCreditor(arg_0), arg_0 -> ((TransactionDetailsBO)transaction).setUltimateDebtor(arg_0), () -> ((TransactionDetailsBO)transaction).getUltimateCreditor(), () -> ((TransactionDetailsBO)transaction).getUltimateDebtor());
        }
        return transaction;
    }

    private <T> void reverse(Consumer<T> consumer1, Consumer<T> consumer2, Supplier<T> supplier1, Supplier<T> supplier2) {
        T temp = supplier1.get();
        consumer1.accept(supplier2.get());
        consumer2.accept(temp);
    }

    private TransactionDetailsBO toTransaction(PostingLineBO pl) {
        if (pl.getDetails() == null) {
            return new TransactionDetailsBO();
        }
        try {
            return (TransactionDetailsBO)this.objectMapper.readValue(pl.getDetails(), TransactionDetailsBO.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public TransactionDetailsMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

