/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import de.adorsys.ledgers.deposit.db.domain.FrequencyCode;
import de.adorsys.ledgers.deposit.db.domain.Payment;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.function.Function;

public final class ExecutionTimeHolder {
    private static final EnumMap<FrequencyCode, Function<Payment, LocalDate>> holder = new EnumMap(FrequencyCode.class);
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int SIX = 6;
    private static final int TWELVE = 12;

    public static LocalDate getExecutionDate(Payment payment) {
        LocalDate nextExecution = holder.get(payment.getFrequency()).apply(payment);
        return payment.getDayOfExecution() == null || EnumSet.of(FrequencyCode.DAILY, FrequencyCode.WEEKLY, FrequencyCode.EVERYTWOWEEKS).contains(payment.getFrequency()) ? nextExecution : LocalDate.of(nextExecution.getYear(), nextExecution.getMonth(), (int)payment.getDayOfExecution());
    }

    private static LocalDate getDateForWeeks(Payment payment, int weeksToAdd) {
        return payment.getExecutedDate().toLocalDate().plusWeeks(weeksToAdd);
    }

    private static LocalDate getDateForMonths(Payment payment, int monthsToAdd) {
        return payment.getStartDate().plusMonths(ExecutionTimeHolder.getMonthDifference(payment) + (long)monthsToAdd);
    }

    private static long getMonthDifference(Payment payment) {
        return ChronoUnit.MONTHS.between(payment.getStartDate(), payment.getExecutedDate().toLocalDate());
    }

    private ExecutionTimeHolder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        holder.put(FrequencyCode.DAILY, p -> p.getExecutedDate().plusDays(1L).toLocalDate());
        holder.put(FrequencyCode.WEEKLY, p -> ExecutionTimeHolder.getDateForWeeks(p, 1));
        holder.put(FrequencyCode.EVERYTWOWEEKS, p -> ExecutionTimeHolder.getDateForWeeks(p, 2));
        holder.put(FrequencyCode.MONTHLY, p -> ExecutionTimeHolder.getDateForMonths(p, 1));
        holder.put(FrequencyCode.EVERYTWOMONTHS, p -> ExecutionTimeHolder.getDateForMonths(p, 2));
        holder.put(FrequencyCode.QUARTERLY, p -> ExecutionTimeHolder.getDateForMonths(p, 3));
        holder.put(FrequencyCode.SEMIANNUAL, p -> ExecutionTimeHolder.getDateForMonths(p, 6));
        holder.put(FrequencyCode.ANNUAL, p -> ExecutionTimeHolder.getDateForMonths(p, 12));
    }
}

