/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceTypeBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.FundsConfirmationRequestBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.deposit.api.service.CurrencyExchangeRatesService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountConfigService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.deposit.api.service.impl.AbstractServiceImpl;
import de.adorsys.ledgers.deposit.api.service.mappers.DepositAccountMapper;
import de.adorsys.ledgers.deposit.api.service.mappers.TransactionDetailsMapper;
import de.adorsys.ledgers.deposit.db.domain.DepositAccount;
import de.adorsys.ledgers.deposit.db.repository.DepositAccountRepository;
import de.adorsys.ledgers.postings.api.domain.AccountStmtBO;
import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerBO;
import de.adorsys.ledgers.postings.api.domain.PostingLineBO;
import de.adorsys.ledgers.postings.api.domain.PostingTraceBO;
import de.adorsys.ledgers.postings.api.service.AccountStmtService;
import de.adorsys.ledgers.postings.api.service.LedgerService;
import de.adorsys.ledgers.postings.api.service.PostingService;
import de.adorsys.ledgers.util.Ids;
import de.adorsys.ledgers.util.exception.DepositErrorCode;
import de.adorsys.ledgers.util.exception.DepositModuleException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.io.IOUtils;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DepositAccountServiceImpl
extends AbstractServiceImpl
implements DepositAccountService {
    private static final Logger log = LoggerFactory.getLogger(DepositAccountServiceImpl.class);
    private static final String MSG_IBAN_NOT_FOUND = "Accounts with iban %s and currency %s not found";
    private static final String MSG_ACCOUNT_NOT_FOUND = "Account with id %s not found";
    private static final String BRANCH_SQL = "classpath:deleteBranch.sql";
    private static final String ROLL_BACK_BRANCH_SQL = "classpath:rollBackBranch.sql";
    private static final String POSTING_SQL = "classpath:deletePostings.sql";
    private static final String USER_SQL = "classpath:deleteUser.sql";
    private static final String ACCOUNT_SQL = "classpath:deleteAccount.sql";
    private static final String DELETE_BRANCH_ERROR_MSG = "Something went wrong during deletion of branch: %s, msg: %s";
    private static final String ROLL_BACK_BRANCH_ERROR_MSG = "Something went wrong during rollback of branch: %s, msg: %s";
    private static final String DELETE_POSTINGS_ERROR_MSG = "Something went wrong during deletion of postings for iban: %s, msg: %s";
    private static final String DELETE_USER_ERROR_MSG = "Something went wrong during deletion of user: %s, msg: %s";
    private static final String DELETE_ACCOUNT_ERROR_MSG = "Something went wrong during deletion of account: %s, msg: %s";
    @PersistenceContext
    private final EntityManager entityManager;
    private final ResourceLoader loader;
    private final DepositAccountRepository depositAccountRepository;
    private final DepositAccountMapper depositAccountMapper = (DepositAccountMapper)Mappers.getMapper(DepositAccountMapper.class);
    private final AccountStmtService accountStmtService;
    private final PostingService postingService;
    private final TransactionDetailsMapper transactionDetailsMapper;
    private final CurrencyExchangeRatesService exchangeRatesService;

    public DepositAccountServiceImpl(DepositAccountConfigService depositAccountConfigService, LedgerService ledgerService, EntityManager entityManager, ResourceLoader loader, DepositAccountRepository depositAccountRepository, AccountStmtService accountStmtService, PostingService postingService, TransactionDetailsMapper transactionDetailsMapper, CurrencyExchangeRatesService exchangeRatesService) {
        super(depositAccountConfigService, ledgerService);
        this.entityManager = entityManager;
        this.loader = loader;
        this.depositAccountRepository = depositAccountRepository;
        this.accountStmtService = accountStmtService;
        this.postingService = postingService;
        this.transactionDetailsMapper = transactionDetailsMapper;
        this.exchangeRatesService = exchangeRatesService;
    }

    public List<DepositAccountBO> getAccountsByIbanAndParamCurrency(String iban, String currency) {
        return this.depositAccountMapper.toDepositAccountListBO(this.depositAccountRepository.findAllByIbanAndCurrencyContaining(iban, currency));
    }

    public DepositAccountBO getAccountByIbanAndCurrency(String iban, Currency currency) {
        return this.getOptionalAccountByIbanAndCurrency(iban, currency).orElseThrow(() -> DepositModuleException.builder().errorCode(DepositErrorCode.DEPOSIT_ACCOUNT_NOT_FOUND).devMsg(String.format(MSG_IBAN_NOT_FOUND, iban, currency)).build());
    }

    public DepositAccountBO getAccountById(String accountId) {
        return this.getOptionalAccountById(accountId).orElseThrow(() -> DepositModuleException.builder().errorCode(DepositErrorCode.DEPOSIT_ACCOUNT_NOT_FOUND).devMsg(String.format(MSG_ACCOUNT_NOT_FOUND, accountId)).build());
    }

    public Optional<DepositAccountBO> getOptionalAccountByIbanAndCurrency(String iban, Currency currency) {
        return this.depositAccountRepository.findByIbanAndCurrency(iban, this.getCurrencyOrEmpty(currency)).map(this.depositAccountMapper::toDepositAccountBO);
    }

    public Optional<DepositAccountBO> getOptionalAccountById(String accountId) {
        return this.depositAccountRepository.findById((Object)accountId).map(this.depositAccountMapper::toDepositAccountBO);
    }

    public DepositAccountDetailsBO getAccountDetailsByIbanAndCurrency(String iban, Currency currency, LocalDateTime refTime, boolean withBalances) {
        return this.getOptionalAccountByIbanAndCurrency(iban, currency).map(d -> new DepositAccountDetailsBO(d, this.getBalancesList((DepositAccountBO)d, withBalances, refTime))).orElseThrow(() -> DepositModuleException.builder().errorCode(DepositErrorCode.DEPOSIT_ACCOUNT_NOT_FOUND).devMsg(String.format(MSG_IBAN_NOT_FOUND, iban, currency)).build());
    }

    public DepositAccountDetailsBO getAccountDetailsById(String accountId, LocalDateTime refTime, boolean withBalances) {
        DepositAccountBO depositAccountBO = this.getDepositAccountById(accountId);
        return new DepositAccountDetailsBO(depositAccountBO, this.getBalancesList(depositAccountBO, withBalances, refTime));
    }

    public TransactionDetailsBO getTransactionById(String accountId, String transactionId) {
        DepositAccountBO account = this.getDepositAccountById(accountId);
        LedgerAccountBO ledgerAccountBO = this.ledgerService.findLedgerAccountById(account.getLinkedAccounts());
        PostingLineBO line = this.postingService.findPostingLineById(ledgerAccountBO, transactionId);
        return this.transactionDetailsMapper.toTransactionSigned(line);
    }

    public List<TransactionDetailsBO> getTransactionsByDates(String accountId, LocalDateTime dateFrom, LocalDateTime dateTo) {
        DepositAccountBO account = this.getDepositAccountById(accountId);
        LedgerAccountBO ledgerAccountBO = this.ledgerService.findLedgerAccountById(account.getLinkedAccounts());
        return this.postingService.findPostingsByDates(ledgerAccountBO, dateFrom, dateTo).stream().map(this.transactionDetailsMapper::toTransactionSigned).collect(Collectors.toList());
    }

    public Page<TransactionDetailsBO> getTransactionsByDatesPaged(String accountId, LocalDateTime dateFrom, LocalDateTime dateTo, Pageable pageable) {
        DepositAccountBO account = this.getDepositAccountById(accountId);
        LedgerAccountBO ledgerAccountBO = this.ledgerService.findLedgerAccountById(account.getLinkedAccounts());
        return this.postingService.findPostingsByDatesPaged(ledgerAccountBO, dateFrom, dateTo, pageable).map(this.transactionDetailsMapper::toTransactionSigned);
    }

    public boolean confirmationOfFunds(FundsConfirmationRequestBO requestBO) {
        DepositAccountDetailsBO account = this.getAccountDetailsByIbanAndCurrency(requestBO.getPsuAccount().getIban(), requestBO.getPsuAccount().getCurrency(), LocalDateTime.now(), true);
        Currency accountCurrency = account.getAccount().getCurrency();
        AmountBO instructedAmount = requestBO.getInstructedAmount();
        BigDecimal appliedRate = this.exchangeRatesService.applyRate(instructedAmount.getCurrency(), accountCurrency, instructedAmount.getAmount());
        requestBO.setInstructedAmount(new AmountBO(account.getAccount().getCurrency(), appliedRate));
        return account.getBalances().stream().filter(b -> b.getBalanceType() == BalanceTypeBO.INTERIM_AVAILABLE).findFirst().map(b -> this.isSufficientAmountAvailable(requestBO, (BalanceBO)b)).orElse(Boolean.FALSE);
    }

    public String readIbanById(String id) {
        return this.depositAccountRepository.findById((Object)id).map(DepositAccount::getIban).orElse(null);
    }

    public List<DepositAccountBO> findByAccountNumberPrefix(String accountNumberPrefix) {
        List accounts = this.depositAccountRepository.findByIbanStartingWith(accountNumberPrefix);
        return this.depositAccountMapper.toDepositAccountListBO(accounts);
    }

    public List<DepositAccountDetailsBO> findDetailsByBranch(String branch) {
        List accounts = this.depositAccountRepository.findByBranch(branch);
        List<DepositAccountBO> accountsBO = this.depositAccountMapper.toDepositAccountListBO(accounts);
        ArrayList<DepositAccountDetailsBO> accountDetails = new ArrayList<DepositAccountDetailsBO>();
        for (DepositAccountBO accountBO : accountsBO) {
            accountDetails.add(new DepositAccountDetailsBO(accountBO, Collections.emptyList()));
        }
        return accountDetails;
    }

    public Page<DepositAccountDetailsBO> findDetailsByBranchPaged(String branch, String queryParam, Pageable pageable) {
        return this.depositAccountRepository.findByBranchAndIbanContaining(branch, queryParam, pageable).map(this.depositAccountMapper::toDepositAccountBO).map(d -> new DepositAccountDetailsBO(d, Collections.emptyList()));
    }

    public void deleteTransactions(String accountId) {
        DepositAccountBO account = this.getAccountById(accountId);
        String linked = account.getLinkedAccounts();
        LedgerAccountBO ledgerAccount = this.ledgerService.findLedgerAccountById(linked);
        this.executeNativeQuery(POSTING_SQL, ledgerAccount.getId(), DELETE_POSTINGS_ERROR_MSG);
    }

    public void deleteBranch(String branchId) {
        this.executeNativeQuery(BRANCH_SQL, branchId, DELETE_BRANCH_ERROR_MSG);
    }

    public void deleteUser(String userId) {
        this.executeNativeQuery(USER_SQL, userId, DELETE_USER_ERROR_MSG);
    }

    public void deleteAccount(String accountId) {
        this.executeNativeQuery(ACCOUNT_SQL, accountId, DELETE_ACCOUNT_ERROR_MSG);
    }

    public void rollBackBranch(String branch, LocalDateTime revertTimestamp) {
        this.executeNativeQuery(ROLL_BACK_BRANCH_SQL, branch, revertTimestamp, ROLL_BACK_BRANCH_ERROR_MSG);
    }

    private void executeNativeQuery(String queryFilePath, String parameter, LocalDateTime timestampParameter, String errorMsg) {
        try {
            InputStream stream = this.loader.getResource(queryFilePath).getInputStream();
            String query = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            this.entityManager.createNativeQuery(query).setParameter(1, (Object)parameter).setParameter(2, (Object)timestampParameter).executeUpdate();
        }
        catch (IOException e) {
            throw DepositModuleException.builder().devMsg(String.format(errorMsg, parameter, e.getMessage())).errorCode(DepositErrorCode.COULD_NOT_EXECUTE_STATEMENT).build();
        }
    }

    public DepositAccountDetailsBO getDetailsByIban(String iban, LocalDateTime refTime, boolean withBalances) {
        List<DepositAccountBO> accounts = this.getAccountsByIbanAndParamCurrency(iban, "");
        if (accounts.size() != 1) {
            throw DepositModuleException.builder().errorCode(DepositErrorCode.DEPOSIT_ACCOUNT_NOT_FOUND).devMsg(String.format(MSG_IBAN_NOT_FOUND, iban, "EMPTY")).build();
        }
        DepositAccountBO account = accounts.iterator().next();
        return new DepositAccountDetailsBO(account, this.getBalancesList(account, withBalances, refTime));
    }

    @Transactional
    public void changeAccountsBlockedStatus(String userId, boolean isSystemBlock, boolean lockStatusToSet) {
        if (isSystemBlock) {
            this.depositAccountRepository.updateSystemBlockedStatus(userId, lockStatusToSet);
        } else {
            this.depositAccountRepository.updateBlockedStatus(userId, lockStatusToSet);
        }
    }

    public Page<DepositAccountBO> findByBranchIdsAndMultipleParams(Collection<String> branchIds, String iban, Boolean blocked, Pageable pageable) {
        List blockedQueryParam = Optional.ofNullable(blocked).map(xva$0 -> Arrays.asList(xva$0)).orElseGet(() -> Arrays.asList(true, false));
        return this.depositAccountRepository.findByBranchInAndIbanContainingAndBlockedInAndSystemBlockedFalse(branchIds, iban, blockedQueryParam, pageable).map(this.depositAccountMapper::toDepositAccountBO);
    }

    public void changeAccountsBlockedStatus(Set<String> accountIds, boolean isSystemBlock, boolean lockStatusToSet) {
        if (isSystemBlock) {
            this.depositAccountRepository.updateSystemBlockedStatus(accountIds, lockStatusToSet);
        } else {
            this.depositAccountRepository.updateBlockedStatus(accountIds, lockStatusToSet);
        }
    }

    public DepositAccountBO createNewAccount(DepositAccountBO depositAccountBO, String userName, String branch) {
        this.checkDepositAccountAlreadyExist(depositAccountBO);
        DepositAccount depositAccount = this.depositAccountMapper.toDepositAccount(depositAccountBO);
        depositAccount.setId(Ids.id());
        depositAccount.setName(userName);
        LedgerAccountBO parentLedgerAccount = new LedgerAccountBO(this.depositAccountConfigService.getDepositParentAccount(), this.loadLedger());
        LedgerAccountBO ledgerAccount = new LedgerAccountBO(depositAccount.getIban(), parentLedgerAccount);
        String accountId = this.ledgerService.newLedgerAccount(ledgerAccount, userName).getId();
        depositAccount.setLinkedAccounts(accountId);
        Optional.ofNullable(branch).ifPresent(arg_0 -> ((DepositAccount)depositAccount).setBranch(arg_0));
        DepositAccount saved = (DepositAccount)this.depositAccountRepository.save((Object)depositAccount);
        return this.depositAccountMapper.toDepositAccountBO(saved);
    }

    private void executeNativeQuery(String queryFilePath, String parameter, String errorMsg) {
        try {
            InputStream stream = this.loader.getResource(queryFilePath).getInputStream();
            String query = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            this.entityManager.createNativeQuery(query).setParameter(1, (Object)parameter).executeUpdate();
        }
        catch (IOException e) {
            throw DepositModuleException.builder().devMsg(String.format(errorMsg, parameter, e.getMessage())).errorCode(DepositErrorCode.COULD_NOT_EXECUTE_STATEMENT).build();
        }
    }

    private void checkDepositAccountAlreadyExist(DepositAccountBO depositAccountBO) {
        boolean isExistingAccount = this.depositAccountRepository.findByIbanAndCurrency(depositAccountBO.getIban(), this.getCurrencyOrEmpty(depositAccountBO.getCurrency())).isPresent();
        if (isExistingAccount) {
            String message = String.format("Deposit account already exists. IBAN %s. Currency %s", depositAccountBO.getIban(), depositAccountBO.getCurrency().getCurrencyCode());
            log.error(message);
            throw DepositModuleException.builder().errorCode(DepositErrorCode.DEPOSIT_ACCOUNT_EXISTS).devMsg(message).build();
        }
    }

    private String getCurrencyOrEmpty(Currency currency) {
        return Optional.ofNullable(currency).map(Currency::getCurrencyCode).orElse("");
    }

    private List<BalanceBO> getBalancesList(DepositAccountBO d, boolean withBalances, LocalDateTime refTime) {
        return withBalances ? this.getBalances(d.getLinkedAccounts(), d.getCurrency(), refTime) : Collections.emptyList();
    }

    private DepositAccountBO getDepositAccountById(String accountId) {
        return this.depositAccountMapper.toDepositAccountBO(this.getDepositAccountEntityById(accountId));
    }

    private DepositAccount getDepositAccountEntityById(String accountId) {
        return (DepositAccount)this.depositAccountRepository.findById((Object)accountId).orElseThrow(() -> DepositModuleException.builder().errorCode(DepositErrorCode.DEPOSIT_ACCOUNT_NOT_FOUND).devMsg(String.format("Account with id: %s not found!", accountId)).build());
    }

    private List<BalanceBO> getBalances(String id, Currency currency, LocalDateTime refTime) {
        LedgerBO ledger = this.loadLedger();
        LedgerAccountBO ledgerAccountBO = new LedgerAccountBO();
        ledgerAccountBO.setLedger(ledger);
        ledgerAccountBO.setId(id);
        return this.getBalances(currency, refTime, ledgerAccountBO);
    }

    private List<BalanceBO> getBalances(Currency currency, LocalDateTime refTime, LedgerAccountBO ledgerAccountBO) {
        AccountStmtBO stmt = this.accountStmtService.readStmt(ledgerAccountBO, refTime);
        BalanceBO interimBalance = this.composeBalance(currency, stmt, BalanceTypeBO.INTERIM_AVAILABLE);
        BalanceBO closingBalance = this.composeBalance(currency, stmt, BalanceTypeBO.CLOSING_BOOKED);
        return Arrays.asList(interimBalance, closingBalance);
    }

    private BalanceBO composeBalance(Currency currency, AccountStmtBO stmt, BalanceTypeBO balanceType) {
        BalanceBO balanceBO = new BalanceBO();
        AmountBO amount = new AmountBO(currency, stmt.creditBalance());
        balanceBO.setAmount(amount);
        balanceBO.setBalanceType(balanceType);
        balanceBO.setReferenceDate(stmt.getPstTime().toLocalDate());
        return this.composeFinalBalance(balanceBO, stmt);
    }

    private BalanceBO composeFinalBalance(BalanceBO balance, AccountStmtBO stmt) {
        PostingTraceBO youngestPst = stmt.getYoungestPst();
        if (youngestPst != null) {
            balance.setLastChangeDateTime(youngestPst.getSrcPstTime());
            balance.setLastCommittedTransaction(youngestPst.getSrcPstId());
        } else {
            balance.setLastChangeDateTime(stmt.getPstTime());
        }
        return balance;
    }

    private boolean isSufficientAmountAvailable(FundsConfirmationRequestBO request, BalanceBO balance) {
        AmountBO balanceAmount = balance.getAmount();
        return Optional.ofNullable(request.getInstructedAmount()).map(r -> balanceAmount.getAmount().compareTo(r.getAmount()) >= 0).orElse(false);
    }
}

