/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.adorsys.ledgers.deposit.api.client.ExchangeRateClient;
import de.adorsys.ledgers.deposit.api.domain.ExchangeRateBO;
import de.adorsys.ledgers.deposit.api.service.CurrencyExchangeRatesService;
import de.adorsys.ledgers.util.exception.DepositErrorCode;
import de.adorsys.ledgers.util.exception.DepositModuleException;
import feign.FeignException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class CurrencyExchangeRatesServiceImpl
implements CurrencyExchangeRatesService {
    private static final Logger log = LoggerFactory.getLogger(CurrencyExchangeRatesServiceImpl.class);
    private static final Currency DEFAULT_ASPSP_CURRENCY = Currency.getInstance("EUR");
    private static final String CURRENCY_FIELD_NAME = "currency";
    private static final String RATE_FIELD_NAME = "rate";
    private static final String DEFAULT_RATE = "1";
    private static Map<Currency, String> rates = new HashMap<Currency, String>();
    private static final String RATE_CONTRACT = "International Currency Exchange Market";
    private final ExchangeRateClient client;
    private final ObjectMapper objectMapper;

    @Scheduled(cron="0 0 8 * * MON-FRI")
    public void updateRates() throws IOException {
        try {
            String body = (String)this.client.getRatesToEur().getBody();
            JSONObject json = XML.toJSONObject((String)body);
            JsonNode tree = (JsonNode)((JsonNode)this.objectMapper.readTree(json.toString()).findValue("Cube").elements().next()).elements().next();
            tree.elements().forEachRemaining(r -> this.mapRate(r.get(RATE_FIELD_NAME), r.get(CURRENCY_FIELD_NAME), rates::put));
            log.info("ExchangeRates updated: {}", (Object)LocalDateTime.now());
        }
        catch (FeignException | IOException e) {
            log.error("Could not update ExchangeRates: {} resetting to default!", (Object)LocalDateTime.now());
            this.loadDefaultRates();
        }
    }

    private void mapRate(JsonNode rate, JsonNode currency, BiConsumer<Currency, String> consumer) {
        Currency currencyValue = (Currency)this.objectMapper.readValue(currency.toString(), Currency.class);
        rates.put(currencyValue, rate.asText());
        consumer.accept(currencyValue, rate.asText());
    }

    private void loadDefaultRates() throws IOException {
        Resource resource = new DefaultResourceLoader().getResource("rates.yml");
        rates = (Map)new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(resource.getInputStream(), (TypeReference)new TypeReference<Map<Currency, String>>(){});
        log.info("ExchangeRates updated to defaults: {}", (Object)LocalDateTime.now());
    }

    public List<ExchangeRateBO> getExchangeRates(Currency debtor, Currency amount, Currency creditor) {
        if (debtor == amount && amount == creditor) {
            return Collections.emptyList();
        }
        ArrayList<ExchangeRateBO> ratesToReturn = new ArrayList<ExchangeRateBO>();
        this.updateRatesList(amount, debtor, rates, ratesToReturn);
        this.updateRatesList(amount, creditor, rates, ratesToReturn);
        return ratesToReturn;
    }

    public BigDecimal applyRate(BigDecimal amount, ExchangeRateBO rate) {
        return Optional.ofNullable(rate).map(r -> amount.divide(this.parseBD(r.getRateFrom()), 4, RoundingMode.HALF_EVEN).multiply(this.parseBD(r.getRateTo()))).orElse(amount);
    }

    public BigDecimal applyRate(Currency curFrom, Currency curTo, BigDecimal value) {
        if (curFrom == curTo) {
            return value;
        }
        ExchangeRateBO rate = this.resolveExchangeRate(curFrom, curTo, rates);
        return this.applyRate(value, rate);
    }

    private BigDecimal parseBD(String value) {
        return NumberUtils.createBigDecimal((String)value);
    }

    private void updateRatesList(Currency curFrom, Currency curTo, Map<Currency, String> rates, List<ExchangeRateBO> ratesToReturn) {
        ExchangeRateBO rate;
        if (curFrom != curTo && !(rate = this.resolveExchangeRate(curFrom, curTo, rates)).getRateFrom().equals(rate.getRateTo())) {
            ratesToReturn.add(rate);
        }
    }

    private ExchangeRateBO resolveExchangeRate(Currency curFrom, Currency curTo, Map<Currency, String> rates) {
        String rateTo;
        String rateFrom;
        if (curFrom != curTo && !(rateFrom = this.resolveRate(curFrom, rates)).equals(rateTo = this.resolveRate(curTo, rates))) {
            return new ExchangeRateBO(curFrom, rateFrom, curTo, rateTo, LocalDate.now(), RATE_CONTRACT);
        }
        return new ExchangeRateBO(curFrom, DEFAULT_RATE, curTo, DEFAULT_RATE, LocalDate.now(), RATE_CONTRACT);
    }

    private String resolveRate(Currency currency, Map<Currency, String> rates) {
        return currency.equals(DEFAULT_ASPSP_CURRENCY) ? DEFAULT_RATE : this.getRate(currency, rates);
    }

    private String getRate(Currency currency, Map<Currency, String> rates) {
        return Optional.ofNullable(rates.get(currency)).orElseThrow(() -> DepositModuleException.builder().errorCode(DepositErrorCode.CURRENCY_NOT_SUPPORTED).devMsg(String.format("Exchange rate for currency: %s not found", currency)).build());
    }

    public CurrencyExchangeRatesServiceImpl(ExchangeRateClient client, ObjectMapper objectMapper) {
        this.client = client;
        this.objectMapper = objectMapper;
    }
}

