/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import de.adorsys.ledgers.deposit.api.service.impl.PaymentExecutionService;
import de.adorsys.ledgers.deposit.db.domain.AccountReference;
import de.adorsys.ledgers.deposit.db.domain.DepositAccount;
import de.adorsys.ledgers.deposit.db.domain.Payment;
import de.adorsys.ledgers.deposit.db.domain.PaymentTarget;
import de.adorsys.ledgers.deposit.db.repository.DepositAccountRepository;
import de.adorsys.ledgers.deposit.db.repository.PaymentRepository;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class PaymentExecutionScheduler {
    private static final Logger log = LoggerFactory.getLogger(PaymentExecutionScheduler.class);
    private static final String SCHEDULER = "Scheduler";
    private final PaymentRepository paymentRepository;
    private final DepositAccountRepository accountRepository;
    private final PaymentExecutionService executionService;

    @Scheduled(initialDelayString="${paymentScheduler.initialDelay}", fixedDelayString="${paymentScheduler.delay}")
    public void scheduler() {
        log.info("Payment Execution Scheduler started at {}", (Object)LocalDateTime.now());
        List payments = this.paymentRepository.getAllDuePayments();
        payments.forEach(this::executeIfNotBlocked);
    }

    private void executeIfNotBlocked(Payment payment) {
        boolean debtorIsEnabled = this.isDebtorAccountEnabled(payment.getAccountId());
        boolean creditorsAreEnabled = this.areTargetsEnabled(payment.getTargets());
        if (debtorIsEnabled && creditorsAreEnabled) {
            this.executionService.executePayment(payment, SCHEDULER);
        }
    }

    private boolean isDebtorAccountEnabled(String accountId) {
        return this.accountRepository.findById((Object)accountId).map(DepositAccount::isEnabled).orElse(false);
    }

    private boolean areTargetsEnabled(List<PaymentTarget> targets) {
        return targets.stream().map(PaymentTarget::getCreditorAccount).allMatch(this::isEnabledCreditorAccount);
    }

    private boolean isEnabledCreditorAccount(AccountReference reference) {
        return this.accountRepository.findByIbanAndCurrency(reference.getIban(), reference.getCurrency()).map(DepositAccount::isEnabled).orElse(true);
    }

    public PaymentExecutionScheduler(PaymentRepository paymentRepository, DepositAccountRepository accountRepository, PaymentExecutionService executionService) {
        this.paymentRepository = paymentRepository;
        this.accountRepository = accountRepository;
        this.executionService = executionService;
    }
}

