/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import de.adorsys.ledgers.deposit.api.service.DepositAccountInitService;
import de.adorsys.ledgers.deposit.api.service.domain.ASPSPConfigSource;
import de.adorsys.ledgers.deposit.api.service.domain.LedgerAccountModel;
import de.adorsys.ledgers.postings.api.domain.AccountCategoryBO;
import de.adorsys.ledgers.postings.api.domain.BalanceSideBO;
import de.adorsys.ledgers.postings.api.domain.ChartOfAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerBO;
import de.adorsys.ledgers.postings.api.service.ChartOfAccountService;
import de.adorsys.ledgers.postings.api.service.LedgerService;
import de.adorsys.ledgers.util.Ids;
import de.adorsys.ledgers.util.exception.PostingModuleException;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DepositAccountInitServiceImpl
implements DepositAccountInitService {
    private static final Logger log = LoggerFactory.getLogger(DepositAccountInitServiceImpl.class);
    private static final String SYSTEM = "System";
    private final ChartOfAccountService coaService;
    private final LedgerService ledgerService;
    private final ASPSPConfigSource configSource;

    public void initConfigData() {
        log.info("Initialising Ledgers");
        LedgerBO ledger = this.getOrCreateLedger();
        this.checkAndUpdateChartOfAccounts(ledger);
    }

    private void checkAndUpdateChartOfAccounts(LedgerBO ledger) {
        log.info("Check Ledger Accounts needs update");
        this.configSource.chartOfAccount(this.configSource.aspspConfigData().getCoaFile()).forEach(a -> this.checkLedgerAccountExistsOrCreate(ledger, (LedgerAccountModel)a));
        this.configSource.aspspConfigData().getCoaExtensions().forEach(a -> this.checkLedgerAccountExistsOrCreate(ledger, (LedgerAccountModel)a));
    }

    private LedgerBO getOrCreateLedger() {
        String ledgerName = this.configSource.aspspConfigData().getLedger();
        ChartOfAccountBO coa = this.getOrCreateCoa(ledgerName);
        log.info("Checking Ledger needs update");
        return this.ledgerService.findLedgerByName(ledgerName).orElseGet(() -> {
            log.info("Ledger created");
            return this.ledgerService.newLedger(new LedgerBO(ledgerName, coa));
        });
    }

    private ChartOfAccountBO getOrCreateCoa(String ledgerName) {
        log.info("Checking Coa needs update");
        return this.coaService.findChartOfAccountsByName(ledgerName).orElseGet(() -> {
            log.info("Coa created");
            return this.coaService.newChartOfAccount(new ChartOfAccountBO(ledgerName));
        });
    }

    private void checkLedgerAccountExistsOrCreate(LedgerBO ledger, LedgerAccountModel model) {
        try {
            this.ledgerService.findLedgerAccount(ledger, model.getName());
            log.info("Ledger Account for {} exists, no update required", (Object)model.getName());
        }
        catch (PostingModuleException ex) {
            log.info("Creating new Ledger Account for {}", (Object)model.getName());
            LedgerAccountBO parent = this.getParentLedgerAccount(ledger, model);
            LedgerAccountBO la = this.newLedgerAccountObj(ledger, model, parent);
            this.ledgerService.newLedgerAccount(la, SYSTEM);
        }
    }

    private LedgerAccountBO getParentLedgerAccount(LedgerBO ledger, LedgerAccountModel model) {
        return model.getParent() != null ? this.ledgerService.findLedgerAccount(ledger, model.getParent()) : null;
    }

    private LedgerAccountBO newLedgerAccountObj(LedgerBO ledger, LedgerAccountModel model, LedgerAccountBO parent) {
        String shortDesc = model.getShortDesc();
        String name = model.getName();
        BalanceSideBO balanceSide = model.getBalanceSide() != null ? model.getBalanceSide() : parent.getBalanceSide();
        AccountCategoryBO category = model.getCategory() != null ? model.getCategory() : parent.getCategory();
        return new LedgerAccountBO(name, Ids.id(), LocalDateTime.now(), null, shortDesc, null, ledger, parent, ledger.getCoa(), balanceSide, category);
    }

    public DepositAccountInitServiceImpl(ChartOfAccountService coaService, LedgerService ledgerService, ASPSPConfigSource configSource) {
        this.coaService = coaService;
        this.ledgerService = ledgerService;
        this.configSource = configSource;
    }
}

