/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.mappers;

import de.adorsys.ledgers.deposit.api.service.mappers.PostingMapper;
import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerBO;
import de.adorsys.ledgers.postings.api.domain.PostingBO;
import de.adorsys.ledgers.postings.api.domain.PostingLineBO;
import de.adorsys.ledgers.postings.api.domain.PostingStatusBO;
import de.adorsys.ledgers.postings.api.domain.PostingTypeBO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.springframework.stereotype.Component;

@Component
public class PostingMapperImpl
implements PostingMapper {
    @Override
    public PostingBO buildPosting(LocalDateTime pstTime, String paymentId, String oprDetails, LedgerBO ledger, String userName) {
        if (pstTime == null && paymentId == null && oprDetails == null && ledger == null && userName == null) {
            return null;
        }
        PostingBO postingBO = new PostingBO();
        if (pstTime != null) {
            postingBO.setValTime(pstTime);
            postingBO.setOprTime(pstTime);
            postingBO.setPstTime(pstTime);
        }
        if (paymentId != null) {
            postingBO.setOprSrc(paymentId);
        }
        if (oprDetails != null) {
            postingBO.setOprDetails(oprDetails);
        }
        if (ledger != null) {
            postingBO.setLedger(ledger);
        }
        if (userName != null) {
            postingBO.setRecordUser(userName);
        }
        postingBO.setPstType(PostingTypeBO.BUSI_TX);
        postingBO.setId(null);
        postingBO.setOprId(this.id());
        postingBO.setPstStatus(PostingStatusBO.POSTED);
        return postingBO;
    }

    @Override
    public PostingLineBO buildPostingLine(String lineDetails, LedgerAccountBO ledgerAccount, BigDecimal debitAmount, BigDecimal creditAmount, String subOprSrcId, String lineId) {
        if (lineDetails == null && ledgerAccount == null && debitAmount == null && creditAmount == null && subOprSrcId == null && lineId == null) {
            return null;
        }
        PostingLineBO postingLineBO = new PostingLineBO();
        if (lineDetails != null) {
            postingLineBO.setDetails(lineDetails);
        }
        if (ledgerAccount != null) {
            postingLineBO.setAccount(ledgerAccount);
        }
        if (debitAmount != null) {
            postingLineBO.setDebitAmount(debitAmount);
        }
        if (creditAmount != null) {
            postingLineBO.setCreditAmount(creditAmount);
        }
        if (subOprSrcId != null) {
            postingLineBO.setSubOprSrcId(subOprSrcId);
        }
        if (lineId != null) {
            postingLineBO.setId(lineId);
        }
        return postingLineBO;
    }
}

