/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.FundsConfirmationRequestBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountConfigService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.deposit.api.service.impl.AbstractServiceImpl;
import de.adorsys.ledgers.deposit.api.service.impl.PaymentExecutionService;
import de.adorsys.ledgers.deposit.api.service.mappers.PaymentMapper;
import de.adorsys.ledgers.deposit.db.domain.AccountReference;
import de.adorsys.ledgers.deposit.db.domain.Payment;
import de.adorsys.ledgers.deposit.db.domain.PaymentType;
import de.adorsys.ledgers.deposit.db.domain.TransactionStatus;
import de.adorsys.ledgers.deposit.db.repository.PaymentRepository;
import de.adorsys.ledgers.postings.api.service.LedgerService;
import de.adorsys.ledgers.util.Ids;
import de.adorsys.ledgers.util.exception.DepositErrorCode;
import de.adorsys.ledgers.util.exception.DepositModuleException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DepositAccountPaymentServiceImpl
extends AbstractServiceImpl
implements DepositAccountPaymentService {
    private static final String PAYMENT_EXECUTION_FAILED = "Payment execution failed due to: %s, payment id: %s";
    private static final String PAYMENT_CANCELLATION_FAILED = "Can`t cancel payment id:%s, as it is already executed";
    @Value(value="${payment-products.instant: instant-sepa-credit-transfers,target-2-payments}")
    private Set<String> instantPayments = new HashSet<String>();
    private final PaymentRepository paymentRepository;
    private final PaymentMapper paymentMapper;
    private final PaymentExecutionService executionService;
    private final DepositAccountService accountService;

    public DepositAccountPaymentServiceImpl(DepositAccountConfigService depositAccountConfigService, LedgerService ledgerService, PaymentRepository paymentRepository, PaymentMapper paymentMapper, PaymentExecutionService executionService, DepositAccountService accountService) {
        super(depositAccountConfigService, ledgerService);
        this.paymentRepository = paymentRepository;
        this.paymentMapper = paymentMapper;
        this.executionService = executionService;
        this.accountService = accountService;
    }

    public TransactionStatusBO getPaymentStatusById(String paymentId) {
        return this.getPaymentById(paymentId).getTransactionStatus();
    }

    public PaymentBO getPaymentById(String paymentId) {
        return this.paymentMapper.toPaymentBO(this.getPaymentEntityById(paymentId));
    }

    public PaymentBO initiatePayment(PaymentBO payment, TransactionStatusBO status) {
        if (this.paymentRepository.existsById((Object)payment.getPaymentId())) {
            throw DepositModuleException.builder().errorCode(DepositErrorCode.PAYMENT_WITH_ID_EXISTS).devMsg(String.format("Payment with id: %s already exists!", payment.getPaymentId())).build();
        }
        Payment paymentToPersist = this.paymentMapper.toPayment(payment);
        paymentToPersist.getTargets().forEach(t -> {
            t.setPayment(paymentToPersist);
            t.setPaymentId(Ids.id());
        });
        AmountBO amountToVerify = this.executionService.calculateTotalPaymentAmount(payment);
        boolean confirmationOfFunds = this.accountService.confirmationOfFunds(new FundsConfirmationRequestBO(null, payment.getDebtorAccount(), amountToVerify, null, null));
        if (confirmationOfFunds) {
            paymentToPersist.setTransactionStatus(TransactionStatus.valueOf((String)status.name()));
            Payment savedPayment = (Payment)this.paymentRepository.save((Object)paymentToPersist);
            return this.paymentMapper.toPaymentBO(savedPayment);
        }
        throw DepositModuleException.builder().errorCode(DepositErrorCode.INSUFFICIENT_FUNDS).devMsg(String.format("Payment with id: %s failed due to Insufficient Funds Available", paymentToPersist.getPaymentId())).build();
    }

    public TransactionStatusBO executePayment(String paymentId, String userName) {
        return this.paymentRepository.findByPaymentIdAndTransactionStatus(paymentId, TransactionStatus.ACTC).map(p -> this.isInstantPayment((Payment)p) ? this.executionService.executePayment((Payment)p, userName) : this.executionService.schedulePayment((Payment)p)).orElseThrow(() -> DepositModuleException.builder().errorCode(DepositErrorCode.PAYMENT_PROCESSING_FAILURE).devMsg(String.format(PAYMENT_EXECUTION_FAILED, "Payment not found", paymentId)).build());
    }

    public TransactionStatusBO cancelPayment(String paymentId) {
        Payment storedPayment = this.getPaymentEntityById(paymentId);
        if (storedPayment.getTransactionStatus() == TransactionStatus.ACSC) {
            throw DepositModuleException.builder().errorCode(DepositErrorCode.PAYMENT_PROCESSING_FAILURE).devMsg(String.format(PAYMENT_CANCELLATION_FAILED, paymentId)).build();
        }
        Payment p = this.updatePaymentStatus(storedPayment, TransactionStatus.CANC);
        return TransactionStatusBO.valueOf((String)p.getTransactionStatus().name());
    }

    public String readIbanByPaymentId(String paymentId) {
        return this.paymentRepository.findById((Object)paymentId).map(Payment::getDebtorAccount).map(AccountReference::getIban).orElse(null);
    }

    public TransactionStatusBO updatePaymentStatus(String paymentId, TransactionStatusBO status) {
        Payment payment = this.getPaymentEntityById(paymentId);
        payment.setTransactionStatus(TransactionStatus.valueOf((String)status.name()));
        Payment p = this.updatePaymentStatus(payment, TransactionStatus.valueOf((String)status.name()));
        return TransactionStatusBO.valueOf((String)p.getTransactionStatus().name());
    }

    public List<PaymentBO> getPaymentsByTypeStatusAndDebtor(PaymentTypeBO paymentType, TransactionStatusBO status, List<AccountReferenceBO> referenceList) {
        List<Payment> payments = referenceList.stream().map(r -> this.paymentRepository.findAllByDebtorAccount(r.getIban(), r.getCurrency().getCurrencyCode(), PaymentType.valueOf((String)paymentType.name()), TransactionStatus.valueOf((String)status.name()))).flatMap(Collection::stream).collect(Collectors.toList());
        return this.paymentMapper.toPaymentBOList(payments);
    }

    private Payment updatePaymentStatus(Payment payment, TransactionStatus updatedStatus) {
        payment.setTransactionStatus(updatedStatus);
        return (Payment)this.paymentRepository.save((Object)payment);
    }

    private Payment getPaymentEntityById(String paymentId) {
        return (Payment)this.paymentRepository.findById((Object)paymentId).orElseThrow(() -> DepositModuleException.builder().errorCode(DepositErrorCode.PAYMENT_NOT_FOUND).devMsg(String.format("Payment with id: %s not found!", paymentId)).build());
    }

    private boolean isInstantPayment(Payment payment) {
        return this.instantPayments.contains(payment.getPaymentProduct());
    }
}

