/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.mappers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.util.exception.DepositErrorCode;
import de.adorsys.ledgers.util.exception.DepositModuleException;
import org.springframework.stereotype.Service;

@Service
public class SerializeService {
    private final ObjectMapper objectMapper;

    public <T> String serializeOprDetails(T orderDetails) {
        try {
            return this.objectMapper.writeValueAsString(orderDetails);
        }
        catch (JsonProcessingException e) {
            throw DepositModuleException.builder().errorCode(DepositErrorCode.PAYMENT_PROCESSING_FAILURE).devMsg(String.format("Payment object can't be serialized, error message: %s", e.getMessage())).build();
        }
    }

    public SerializeService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

