/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.MockBookingDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentOrderDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountConfigService;
import de.adorsys.ledgers.deposit.api.service.TransactionService;
import de.adorsys.ledgers.deposit.api.service.mappers.SerializeService;
import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerBO;
import de.adorsys.ledgers.postings.api.domain.PostingBO;
import de.adorsys.ledgers.postings.api.domain.PostingLineBO;
import de.adorsys.ledgers.postings.api.domain.PostingStatusBO;
import de.adorsys.ledgers.postings.api.domain.PostingTypeBO;
import de.adorsys.ledgers.postings.api.service.LedgerService;
import de.adorsys.ledgers.postings.api.service.PostingMockService;
import de.adorsys.ledgers.util.Ids;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransactionServiceImpl
implements TransactionService {
    private static final Logger log = LoggerFactory.getLogger(TransactionServiceImpl.class);
    private static final String MOCK_DATA_IMPORT = "MockDataImport";
    private static final String SEPA_CLEARING_ACCOUNT = "11031";
    private static final int NANO_TO_SECOND = 1000000000;
    private final SerializeService serializeService;
    private final PostingMockService postingService;
    private final LedgerService ledgerService;
    private final DepositAccountConfigService depositAccountConfigService;

    public Map<String, String> bookMockTransaction(List<MockBookingDetailsBO> trDetails) {
        log.info("Start upload mock transactions, size: {}", (Object)trDetails.size());
        long start = System.nanoTime();
        LedgerBO ledger = this.loadLedger();
        log.info("Loaded Ledger in {} seconds from start", (Object)((double)(System.nanoTime() - start) / 1.0E9));
        Map<String, LedgerAccountBO> accounts = this.getAccounts(trDetails, ledger);
        log.info("Loaded Accounts in {} seconds from start", (Object)((double)(System.nanoTime() - start) / 1.0E9));
        ArrayList postings = new ArrayList();
        HashMap<String, String> errorMap = new HashMap<String, String>();
        trDetails.forEach(d -> {
            try {
                postings.add(this.preparePosting((MockBookingDetailsBO)d, ledger, accounts));
            }
            catch (Exception e) {
                errorMap.put(d.toString(), e.getMessage());
            }
        });
        log.info("Populated postings in {} seconds from start", (Object)((double)(System.nanoTime() - start) / 1.0E9));
        this.postingService.addPostingsAsBatch(postings);
        log.info("Initiation completed in {} seconds, errors: {}, av: {} seconds/transaction", new Object[]{(double)(System.nanoTime() - start) / 1.0E9, errorMap.size(), (double)(System.nanoTime() - start) / 1.0E9 / (double)trDetails.size()});
        return errorMap;
    }

    private Map<String, LedgerAccountBO> getAccounts(List<MockBookingDetailsBO> transactions, LedgerBO ledger) {
        long start = System.nanoTime();
        HashSet<String> ibans = new HashSet<String>();
        transactions.forEach(t -> {
            ibans.add(t.getUserAccount());
            ibans.add(t.getOtherAccount());
        });
        ibans.add(SEPA_CLEARING_ACCOUNT);
        Map ledgerAccounts = this.ledgerService.finLedgerAccountsByIbans(ibans, ledger);
        log.info("Selected {} accounts in {}", (Object)ledgerAccounts.size(), (Object)((double)(System.nanoTime() - start) / 1.0E9));
        return ledgerAccounts;
    }

    private PostingBO preparePosting(MockBookingDetailsBO details, LedgerBO ledger, Map<String, LedgerAccountBO> accounts) {
        return details.isPaymentTransaction() ? this.preparePaymentPosting(ledger, details, accounts) : this.prepareDepositPosting(ledger, details, accounts);
    }

    private LedgerBO loadLedger() {
        String ledgerName = this.depositAccountConfigService.getLedger();
        return (LedgerBO)this.ledgerService.findLedgerByName(ledgerName).orElseThrow(() -> new IllegalStateException(String.format("Ledger with name %s not found", ledgerName)));
    }

    private PostingBO prepareDepositPosting(LedgerBO ledger, MockBookingDetailsBO details, Map<String, LedgerAccountBO> accounts) {
        AccountReferenceBO debtorAccount = this.getAccountReference(details.getOtherAccount(), details);
        PostingBO posting = this.composePosting(ledger, details, debtorAccount);
        PostingLineBO debitLine = this.composeLine(posting, details, false, true, accounts);
        PostingLineBO creditLine = this.composeLine(posting, details, false, false, accounts);
        posting.setLines(Arrays.asList(debitLine, creditLine));
        return posting;
    }

    private PostingBO preparePaymentPosting(LedgerBO ledger, MockBookingDetailsBO details, Map<String, LedgerAccountBO> accounts) {
        AccountReferenceBO debtorAccount = this.getAccountReference(details.getUserAccount(), details);
        PostingBO posting = this.composePosting(ledger, details, debtorAccount);
        PostingLineBO debitLine = this.composeLine(posting, details, true, true, accounts);
        PostingLineBO creditLine = this.composeLine(posting, details, true, false, accounts);
        posting.setLines(Arrays.asList(debitLine, creditLine));
        return posting;
    }

    private PostingLineBO composeLine(PostingBO posting, MockBookingDetailsBO details, boolean isPayment, boolean isDebitLine, Map<String, LedgerAccountBO> accounts) {
        PostingLineBO line = new PostingLineBO();
        line.setId(Ids.id());
        line.setAccount(isDebitLine ? this.resolveAccountForDebitLine(details, isPayment, accounts) : this.resolveAccountForCreditLine(details, isPayment, accounts));
        line.setDebitAmount(isDebitLine ? this.resolveAmountByOperationType(details, isPayment) : BigDecimal.ZERO);
        line.setCreditAmount(isDebitLine ? BigDecimal.ZERO : this.resolveAmountByOperationType(details, isPayment));
        return this.fillCommonPostingLineFields(posting, details, line);
    }

    private BigDecimal resolveAmountByOperationType(MockBookingDetailsBO details, boolean isPayment) {
        return isPayment ? details.getAmount().negate() : details.getAmount();
    }

    private LedgerAccountBO resolveAccountForDebitLine(MockBookingDetailsBO details, boolean isPayment, Map<String, LedgerAccountBO> accounts) {
        return isPayment ? accounts.get(details.getUserAccount()) : this.checkOtherAccountOrLoadClearing(details, accounts);
    }

    private LedgerAccountBO resolveAccountForCreditLine(MockBookingDetailsBO details, boolean isPayment, Map<String, LedgerAccountBO> accounts) {
        return isPayment ? this.checkOtherAccountOrLoadClearing(details, accounts) : accounts.get(details.getUserAccount());
    }

    private LedgerAccountBO checkOtherAccountOrLoadClearing(MockBookingDetailsBO details, Map<String, LedgerAccountBO> accounts) {
        return Optional.ofNullable(accounts.get(details.getOtherAccount())).orElseGet(() -> (LedgerAccountBO)accounts.get(SEPA_CLEARING_ACCOUNT));
    }

    private PostingLineBO fillCommonPostingLineFields(PostingBO posting, MockBookingDetailsBO details, PostingLineBO line) {
        String lineDetails = this.createPostingLineDetails(details, line.getId());
        line.setDetails(lineDetails);
        line.setSubOprSrcId(posting.getOprId());
        line.setOprId(posting.getOprId());
        line.setPstTime(posting.getPstTime());
        line.setPstType(PostingTypeBO.BUSI_TX);
        line.setPstStatus(PostingStatusBO.POSTED);
        return line;
    }

    private PostingBO composePosting(LedgerBO ledger, MockBookingDetailsBO details, AccountReferenceBO debtorAccount) {
        PostingBO posting = new PostingBO();
        String postingDetails = this.createPostingDetails(details, debtorAccount);
        posting.setOprId(Ids.id());
        posting.setOprTime(LocalDateTime.now());
        posting.setOprDetails(postingDetails);
        posting.setOprType(MOCK_DATA_IMPORT);
        posting.setOprSrc(MOCK_DATA_IMPORT);
        posting.setRecordUser(details.getCrDrName());
        posting.setPstTime(details.getBookingDate().atTime(LocalTime.now()));
        posting.setPstType(PostingTypeBO.BUSI_TX);
        posting.setPstStatus(PostingStatusBO.POSTED);
        posting.setLedger(ledger);
        posting.setValTime(details.getValueDate().atTime(LocalTime.now()));
        return posting;
    }

    private String createPostingDetails(MockBookingDetailsBO details, AccountReferenceBO account) {
        return this.serializeService.serializeOprDetails(new PaymentOrderDetailsBO(null, Boolean.valueOf(false), details.getBookingDate(), LocalTime.now(), PaymentTypeBO.SINGLE, "instant-sepa-credit-transfers", null, null, null, null, null, account, TransactionStatusBO.ACSC));
    }

    private String createPostingLineDetails(MockBookingDetailsBO details, String lineId) {
        TransactionDetailsBO lineDetails = new TransactionDetailsBO();
        lineDetails.setTransactionId(lineId);
        lineDetails.setEndToEndId(UUID.randomUUID().toString());
        lineDetails.setBookingDate(details.getBookingDate());
        lineDetails.setValueDate(details.getValueDate());
        lineDetails.setTransactionAmount(new AmountBO(details.getCurrency(), details.isPaymentTransaction() ? details.getAmount().negate() : details.getAmount()));
        lineDetails.setCreditorName(details.getCrDrName());
        AccountReferenceBO creditor = this.getCrDrReference(details, details.isPaymentTransaction());
        lineDetails.setCreditorAccount(creditor);
        AccountReferenceBO debtor = this.getCrDrReference(details, !details.isPaymentTransaction());
        lineDetails.setDebtorAccount(debtor);
        lineDetails.setRemittanceInformationUnstructured(details.getRemittance());
        return this.serializeService.serializeOprDetails(lineDetails);
    }

    private AccountReferenceBO getCrDrReference(MockBookingDetailsBO details, boolean isPaymentOperation) {
        return this.getAccountReference(isPaymentOperation ? details.getUserAccount() : details.getOtherAccount(), details);
    }

    private AccountReferenceBO getAccountReference(String iban, MockBookingDetailsBO details) {
        AccountReferenceBO reference = new AccountReferenceBO();
        reference.setCurrency(details.getCurrency());
        reference.setIban(iban);
        return reference;
    }

    public TransactionServiceImpl(SerializeService serializeService, PostingMockService postingService, LedgerService ledgerService, DepositAccountConfigService depositAccountConfigService) {
        this.serializeService = serializeService;
        this.postingService = postingService;
        this.ledgerService = ledgerService;
        this.depositAccountConfigService = depositAccountConfigService;
    }
}

