/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import de.adorsys.ledgers.deposit.api.service.DepositAccountConfigService;
import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerBO;
import de.adorsys.ledgers.postings.api.service.LedgerService;

public abstract class AbstractServiceImpl {
    protected final DepositAccountConfigService depositAccountConfigService;
    protected final LedgerService ledgerService;

    protected LedgerBO loadLedger() {
        String ledgerName = this.depositAccountConfigService.getLedger();
        return (LedgerBO)this.ledgerService.findLedgerByName(ledgerName).orElseThrow(() -> new IllegalStateException(String.format("Ledger with name %s not found", ledgerName)));
    }

    protected LedgerAccountBO loadClearingAccount(LedgerBO ledgerBO, String paymentProductBO) {
        String clearingAccount = this.depositAccountConfigService.getClearingAccount(paymentProductBO);
        return this.ledgerService.findLedgerAccount(ledgerBO, clearingAccount);
    }

    public AbstractServiceImpl(DepositAccountConfigService depositAccountConfigService, LedgerService ledgerService) {
        this.depositAccountConfigService = depositAccountConfigService;
        this.ledgerService = ledgerService;
    }
}

