/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceTypeBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.ExchangeRateBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.deposit.api.service.CurrencyExchangeRatesService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountConfigService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountTransactionService;
import de.adorsys.ledgers.deposit.api.service.impl.AbstractServiceImpl;
import de.adorsys.ledgers.deposit.api.service.mappers.PaymentMapper;
import de.adorsys.ledgers.deposit.api.service.mappers.PostingMapper;
import de.adorsys.ledgers.deposit.api.service.mappers.SerializeService;
import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerBO;
import de.adorsys.ledgers.postings.api.domain.PostingBO;
import de.adorsys.ledgers.postings.api.domain.PostingLineBO;
import de.adorsys.ledgers.postings.api.service.LedgerService;
import de.adorsys.ledgers.postings.api.service.PostingService;
import de.adorsys.ledgers.util.Ids;
import de.adorsys.ledgers.util.exception.DepositErrorCode;
import de.adorsys.ledgers.util.exception.DepositModuleException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class DepositAccountTransactionServiceImpl
extends AbstractServiceImpl
implements DepositAccountTransactionService {
    private final PaymentMapper paymentMapper;
    private final PostingMapper postingMapper;
    private final PostingService postingService;
    private final SerializeService serializeService;
    private final DepositAccountService depositAccountService;
    private final CurrencyExchangeRatesService exchangeRatesService;

    public DepositAccountTransactionServiceImpl(PostingService postingService, LedgerService ledgerService, DepositAccountConfigService depositAccountConfigService, PaymentMapper paymentMapper, PostingMapper postingMapper, SerializeService serializeService, DepositAccountService depositAccountService, CurrencyExchangeRatesService exchangeRatesService) {
        super(depositAccountConfigService, ledgerService);
        this.postingService = postingService;
        this.paymentMapper = paymentMapper;
        this.postingMapper = postingMapper;
        this.serializeService = serializeService;
        this.depositAccountService = depositAccountService;
        this.exchangeRatesService = exchangeRatesService;
    }

    public void depositCash(String accountId, AmountBO amount, String recordUser) {
        if (amount.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw DepositModuleException.builder().errorCode(DepositErrorCode.DEPOSIT_OPERATION_FAILURE).devMsg("Deposited amount must be greater than zero").build();
        }
        DepositAccountDetailsBO depositAccount = this.depositAccountService.getAccountDetailsById(accountId, LocalDateTime.now(), true);
        Currency accountCurrency = depositAccount.getAccount().getCurrency();
        if (!accountCurrency.equals(amount.getCurrency())) {
            throw DepositModuleException.builder().errorCode(DepositErrorCode.DEPOSIT_OPERATION_FAILURE).devMsg(String.format("Deposited amount and account currencies are different. Requested currency: %s, Account currency: %s", amount.getCurrency().getCurrencyCode(), accountCurrency)).build();
        }
        LedgerBO ledger = this.loadLedger();
        LocalDateTime postingDateTime = LocalDateTime.now();
        this.depositCash(depositAccount, amount, recordUser, ledger, postingDateTime);
    }

    public void bookPayment(PaymentBO payment, LocalDateTime pstTime, String userName) {
        String oprDetails = this.serializeService.serializeOprDetails(this.paymentMapper.toPaymentOrder(payment));
        LedgerBO ledger = this.loadLedger();
        if (payment.getPaymentType() == PaymentTypeBO.BULK && Optional.ofNullable(payment.getBatchBookingPreferred()).orElse(false).booleanValue()) {
            this.createBatchPostings(pstTime, oprDetails, ledger, payment, userName);
        } else {
            this.createRegularPostings(pstTime, oprDetails, ledger, payment, userName);
        }
    }

    private void depositCash(DepositAccountDetailsBO depositAccount, AmountBO amount, String recordUser, LedgerBO ledger, LocalDateTime postingDateTime) {
        PostingBO posting = this.postingMapper.buildPosting(postingDateTime, Ids.id(), "ATM Cash Deposit", ledger, recordUser);
        PostingLineBO debitLine = this.composeLine(depositAccount, amount, ledger, postingDateTime, true);
        PostingLineBO creditLine = this.composeLine(depositAccount, amount, ledger, postingDateTime, false);
        posting.getLines().addAll(Arrays.asList(debitLine, creditLine));
        this.postingService.newPosting(posting);
    }

    private PostingLineBO composeLine(DepositAccountDetailsBO depositAccount, AmountBO amount, LedgerBO ledger, LocalDateTime postingDateTime, boolean debit) {
        DepositAccountBO account = depositAccount.getAccount();
        LedgerAccountBO ledgerAccount = debit ? this.ledgerService.findLedgerAccount(ledger, this.depositAccountConfigService.getCashAccount()) : this.ledgerService.findLedgerAccountById(account.getLinkedAccounts());
        BigDecimal debitAmount = this.getDCtAmount(amount, debit, null);
        BigDecimal creditAmount = this.getDCtAmount(amount, !debit, null);
        BalanceBO balanceAfterTransaction = this.resolveBalanceAfterTransaction(!debit, depositAccount, debitAmount);
        String lineId = Ids.id();
        AccountReferenceBO creditor = account.getReference();
        String debitTransactionDetails = this.serializeService.serializeOprDetails(this.paymentMapper.toDepositTransactionDetails(amount, account, creditor, postingDateTime.toLocalDate(), lineId, balanceAfterTransaction));
        return this.postingMapper.buildPostingLine(debitTransactionDetails, ledgerAccount, debitAmount, creditAmount, "ATM transfer", lineId);
    }

    private BalanceBO resolveBalanceAfterTransaction(boolean debit, DepositAccountDetailsBO details, BigDecimal amount) {
        Optional<BalanceBO> balanceAfterTransaction = Optional.ofNullable(details).map(DepositAccountDetailsBO::getBalances).map(this::getBalance);
        balanceAfterTransaction.ifPresent(b -> b.updateAmount(amount, debit ? BigDecimal::subtract : BigDecimal::add));
        return balanceAfterTransaction.orElse(null);
    }

    private BalanceBO resolveBalanceAfterTransactionForPayment(boolean debit, PaymentTargetBO target, BigDecimal amount) {
        DepositAccountDetailsBO accountDetails = debit ? this.depositAccountService.getAccountDetailsById(target.getPayment().getAccountId(), LocalDateTime.now(), true) : this.getAccount(target.getCreditorAccount().getIban(), target.getCreditorAccount().getCurrency());
        return this.resolveBalanceAfterTransaction(debit, accountDetails, amount);
    }

    private BalanceBO getBalance(List<BalanceBO> balances) {
        return balances.stream().filter(b -> b.getBalanceType() == BalanceTypeBO.INTERIM_AVAILABLE).findFirst().orElse(null);
    }

    private void createRegularPostings(LocalDateTime pstTime, String oprDetails, LedgerBO ledger, PaymentBO payment, String userName) {
        payment.getTargets().stream().map(t -> {
            t.setPayment(payment);
            return this.buildDCPosting(pstTime, oprDetails, ledger, (PaymentTargetBO)t, userName);
        }).forEach(arg_0 -> ((PostingService)this.postingService).newPosting(arg_0));
    }

    private void createBatchPostings(LocalDateTime pstTime, String oprDetails, LedgerBO ledger, PaymentBO payment, String userName) {
        PostingBO posting = this.postingMapper.buildPosting(pstTime, payment.getPaymentId(), oprDetails, ledger, userName);
        ArrayList<ExchangeRateBO> ratesForDebitLine = new ArrayList<ExchangeRateBO>();
        BigDecimal batchAmount = BigDecimal.ZERO;
        ArrayList<PostingLineBO> creditLines = new ArrayList<PostingLineBO>();
        for (PaymentTargetBO t : payment.getTargets()) {
            t.setPayment(payment);
            List rates = this.exchangeRatesService.getExchangeRates(payment.getDebtorAccount().getCurrency(), t.getInstructedAmount().getCurrency(), t.getCreditorAccount().getCurrency());
            Optional.ofNullable(this.resolveRateIfRequired(payment.getDebtorAccount(), rates)).ifPresent(ratesForDebitLine::add);
            PostingLineBO line = this.createLine(ledger, t, pstTime, rates, payment.getPaymentId(), false, true);
            creditLines.add(line);
            batchAmount = batchAmount.add(line.getCreditAmount());
            if (!this.additionalLinesRequired(t)) continue;
            PostingLineBO additionalCreditLine = this.createLine(ledger, t, pstTime, rates, t.getPayment().getPaymentId(), true, false);
            creditLines.add(additionalCreditLine);
        }
        AmountBO amount = new AmountBO(payment.getDebtorAccount().getCurrency(), batchAmount);
        String id = Ids.id();
        BalanceBO balanceAfterTransaction = this.resolveBalanceAfterTransaction(true, this.depositAccountService.getAccountDetailsById(payment.getAccountId(), LocalDateTime.now(), true), batchAmount);
        ratesForDebitLine = ratesForDebitLine.isEmpty() ? null : ratesForDebitLine;
        String debitLineDetails = this.serializeService.serializeOprDetails(this.paymentMapper.toPaymentTargetDetailsBatch(id, payment, amount, pstTime.toLocalDate(), ratesForDebitLine, balanceAfterTransaction));
        LedgerAccountBO debtorLedgerAccount = this.getLedgerAccount(ledger, payment.getPaymentProduct(), payment.getDebtorAccount(), true, true, false);
        PostingLineBO debitLine = this.postingMapper.buildPostingLine(debitLineDetails, debtorLedgerAccount, amount.getAmount(), BigDecimal.ZERO, payment.getPaymentId(), id);
        posting.getLines().add(debitLine);
        posting.getLines().addAll(creditLines);
        this.postingService.newPosting(posting);
    }

    private PostingBO buildDCPosting(LocalDateTime pstTime, String oprDetails, LedgerBO ledger, PaymentTargetBO target, String userName) {
        PostingBO posting = this.postingMapper.buildPosting(pstTime, target.getPayment().getPaymentId(), oprDetails, ledger, userName);
        List rates = this.exchangeRatesService.getExchangeRates(target.getPayment().getDebtorAccount().getCurrency(), target.getInstructedAmount().getCurrency(), target.getCreditorAccount().getCurrency());
        PostingLineBO debitLine = this.createLine(ledger, target, pstTime, rates, posting.getOprId(), true, true);
        PostingLineBO creditLine = this.createLine(ledger, target, pstTime, rates, target.getPayment().getPaymentId(), false, true);
        posting.getLines().addAll(Arrays.asList(debitLine, creditLine));
        if (this.additionalLinesRequired(target)) {
            PostingLineBO additionalDebitLine = this.createLine(ledger, target, pstTime, rates, posting.getOprId(), true, false);
            PostingLineBO additionalCreditLine = this.createLine(ledger, target, pstTime, rates, target.getPayment().getPaymentId(), false, false);
            posting.getLines().addAll(Arrays.asList(additionalDebitLine, additionalCreditLine));
        }
        return posting;
    }

    private boolean additionalLinesRequired(PaymentTargetBO target) {
        return !target.isAllCurrenciesMatch() && this.ledgerAccountId(target.getCreditorAccount()).isPresent();
    }

    private PostingLineBO createLine(LedgerBO ledger, PaymentTargetBO target, LocalDateTime pstTime, List<ExchangeRateBO> rates, String oprId, boolean isDebitLine, boolean isFirstLine) {
        String id = Ids.id();
        ExchangeRateBO ratesForLine = this.resolveRateIfRequired(this.getReferenceByValue(target, isFirstLine), rates);
        LedgerAccountBO ledgerAccount = this.getLedgerAccount(ledger, target.getPayment().getPaymentProduct(), this.getReferenceByValue(target, isDebitLine), isDebitLine, isFirstLine, target.isAllCurrenciesMatch());
        BigDecimal debitAmount = this.getDCtAmount(target.getInstructedAmount(), isDebitLine, ratesForLine);
        BigDecimal creditAmount = this.getDCtAmount(target.getInstructedAmount(), !isDebitLine, ratesForLine);
        BalanceBO balanceAfterTransaction = this.resolveBalanceAfterTransactionForPayment(isDebitLine, target, isDebitLine ? debitAmount : creditAmount);
        String targetDetails = this.serializeService.serializeOprDetails(this.paymentMapper.toPaymentTargetDetails(id, target, pstTime.toLocalDate(), Optional.ofNullable(ratesForLine).map(Collections::singletonList).orElse(null), balanceAfterTransaction));
        return this.postingMapper.buildPostingLine(targetDetails, ledgerAccount, debitAmount, creditAmount, oprId, id);
    }

    private DepositAccountDetailsBO getAccount(String iban, Currency currency) {
        try {
            return this.depositAccountService.getAccountDetailsByIbanAndCurrency(iban, currency, LocalDateTime.now(), true);
        }
        catch (DepositModuleException e) {
            return null;
        }
    }

    private AccountReferenceBO getReferenceByValue(PaymentTargetBO target, boolean value) {
        return value ? target.getPayment().getDebtorAccount() : target.getCreditorAccount();
    }

    private ExchangeRateBO resolveRateIfRequired(AccountReferenceBO reference, List<ExchangeRateBO> rates) {
        return rates.stream().filter(r -> reference.getCurrency().equals(r.getCurrencyTo())).findFirst().orElse(null);
    }

    private BigDecimal getDCtAmount(AmountBO amount, boolean debit, ExchangeRateBO rate) {
        return debit ? this.exchangeRatesService.applyRate(amount.getAmount(), rate) : BigDecimal.ZERO;
    }

    private LedgerAccountBO getLedgerAccount(LedgerBO ledger, String paymentProduct, AccountReferenceBO reference, boolean isDebitLine, boolean isFirstLine, boolean isAllCurrenciesMatch) {
        block5: {
            block4: {
                if (isAllCurrenciesMatch) {
                    return this.ledgerAccountId(reference).map(arg_0 -> ((LedgerService)this.ledgerService).findLedgerAccountById(arg_0)).orElseGet(() -> this.loadClearingAccount(ledger, paymentProduct));
                }
                if (isDebitLine && isFirstLine) break block4;
                if (isDebitLine || isFirstLine) break block5;
            }
            return this.ledgerAccountId(reference).map(arg_0 -> ((LedgerService)this.ledgerService).findLedgerAccountById(arg_0)).orElseThrow(() -> DepositModuleException.builder().errorCode(DepositErrorCode.DEPOSIT_ACCOUNT_NOT_FOUND).devMsg(String.format("Account with IBAN: %s not found", reference.getIban())).build());
        }
        return this.loadClearingAccount(ledger, paymentProduct);
    }

    private Optional<String> ledgerAccountId(AccountReferenceBO reference) {
        return this.depositAccountService.getOptionalAccountByIbanAndCurrency(reference.getIban(), reference.getCurrency()).map(DepositAccountBO::getLinkedAccounts);
    }
}

