/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.domain;

import de.adorsys.ledgers.deposit.api.service.domain.ClearingAccount;
import de.adorsys.ledgers.deposit.api.service.domain.LedgerAccountModel;
import java.util.ArrayList;
import java.util.List;

public class ASPSPConfigData {
    private String name;
    private String ledger;
    private String coaFile;
    private String depositParentAccount;
    private List<LedgerAccountModel> coaExtensions = new ArrayList<LedgerAccountModel>();
    private List<ClearingAccount> clearingAccounts = new ArrayList<ClearingAccount>();
    private String cashAccount;
    private String updateMarkerAccountNbr;

    public String getClearingAccount(String paymentProduct) {
        return this.clearingAccounts.stream().filter(a -> a.getPaymentProduct().equalsIgnoreCase(paymentProduct)).map(ClearingAccount::getAccountNbr).findFirst().orElseGet(() -> this.getClearingAccount("others"));
    }

    public String getName() {
        return this.name;
    }

    public String getLedger() {
        return this.ledger;
    }

    public String getCoaFile() {
        return this.coaFile;
    }

    public String getDepositParentAccount() {
        return this.depositParentAccount;
    }

    public List<LedgerAccountModel> getCoaExtensions() {
        return this.coaExtensions;
    }

    public List<ClearingAccount> getClearingAccounts() {
        return this.clearingAccounts;
    }

    public String getCashAccount() {
        return this.cashAccount;
    }

    public String getUpdateMarkerAccountNbr() {
        return this.updateMarkerAccountNbr;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLedger(String ledger) {
        this.ledger = ledger;
    }

    public void setCoaFile(String coaFile) {
        this.coaFile = coaFile;
    }

    public void setDepositParentAccount(String depositParentAccount) {
        this.depositParentAccount = depositParentAccount;
    }

    public void setCoaExtensions(List<LedgerAccountModel> coaExtensions) {
        this.coaExtensions = coaExtensions;
    }

    public void setClearingAccounts(List<ClearingAccount> clearingAccounts) {
        this.clearingAccounts = clearingAccounts;
    }

    public void setCashAccount(String cashAccount) {
        this.cashAccount = cashAccount;
    }

    public void setUpdateMarkerAccountNbr(String updateMarkerAccountNbr) {
        this.updateMarkerAccountNbr = updateMarkerAccountNbr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ASPSPConfigData)) {
            return false;
        }
        ASPSPConfigData other = (ASPSPConfigData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$ledger = this.getLedger();
        String other$ledger = other.getLedger();
        if (this$ledger == null ? other$ledger != null : !this$ledger.equals(other$ledger)) {
            return false;
        }
        String this$coaFile = this.getCoaFile();
        String other$coaFile = other.getCoaFile();
        if (this$coaFile == null ? other$coaFile != null : !this$coaFile.equals(other$coaFile)) {
            return false;
        }
        String this$depositParentAccount = this.getDepositParentAccount();
        String other$depositParentAccount = other.getDepositParentAccount();
        if (this$depositParentAccount == null ? other$depositParentAccount != null : !this$depositParentAccount.equals(other$depositParentAccount)) {
            return false;
        }
        List<LedgerAccountModel> this$coaExtensions = this.getCoaExtensions();
        List<LedgerAccountModel> other$coaExtensions = other.getCoaExtensions();
        if (this$coaExtensions == null ? other$coaExtensions != null : !((Object)this$coaExtensions).equals(other$coaExtensions)) {
            return false;
        }
        List<ClearingAccount> this$clearingAccounts = this.getClearingAccounts();
        List<ClearingAccount> other$clearingAccounts = other.getClearingAccounts();
        if (this$clearingAccounts == null ? other$clearingAccounts != null : !((Object)this$clearingAccounts).equals(other$clearingAccounts)) {
            return false;
        }
        String this$cashAccount = this.getCashAccount();
        String other$cashAccount = other.getCashAccount();
        if (this$cashAccount == null ? other$cashAccount != null : !this$cashAccount.equals(other$cashAccount)) {
            return false;
        }
        String this$updateMarkerAccountNbr = this.getUpdateMarkerAccountNbr();
        String other$updateMarkerAccountNbr = other.getUpdateMarkerAccountNbr();
        return !(this$updateMarkerAccountNbr == null ? other$updateMarkerAccountNbr != null : !this$updateMarkerAccountNbr.equals(other$updateMarkerAccountNbr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ASPSPConfigData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $ledger = this.getLedger();
        result = result * 59 + ($ledger == null ? 43 : $ledger.hashCode());
        String $coaFile = this.getCoaFile();
        result = result * 59 + ($coaFile == null ? 43 : $coaFile.hashCode());
        String $depositParentAccount = this.getDepositParentAccount();
        result = result * 59 + ($depositParentAccount == null ? 43 : $depositParentAccount.hashCode());
        List<LedgerAccountModel> $coaExtensions = this.getCoaExtensions();
        result = result * 59 + ($coaExtensions == null ? 43 : ((Object)$coaExtensions).hashCode());
        List<ClearingAccount> $clearingAccounts = this.getClearingAccounts();
        result = result * 59 + ($clearingAccounts == null ? 43 : ((Object)$clearingAccounts).hashCode());
        String $cashAccount = this.getCashAccount();
        result = result * 59 + ($cashAccount == null ? 43 : $cashAccount.hashCode());
        String $updateMarkerAccountNbr = this.getUpdateMarkerAccountNbr();
        result = result * 59 + ($updateMarkerAccountNbr == null ? 43 : $updateMarkerAccountNbr.hashCode());
        return result;
    }

    public String toString() {
        return "ASPSPConfigData(name=" + this.getName() + ", ledger=" + this.getLedger() + ", coaFile=" + this.getCoaFile() + ", depositParentAccount=" + this.getDepositParentAccount() + ", coaExtensions=" + this.getCoaExtensions() + ", clearingAccounts=" + this.getClearingAccounts() + ", cashAccount=" + this.getCashAccount() + ", updateMarkerAccountNbr=" + this.getUpdateMarkerAccountNbr() + ")";
    }
}

