package de.adorsys.ledgers.deposit.api.service.mappers;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AccountStatusBO;
import de.adorsys.ledgers.deposit.api.domain.AccountTypeBO;
import de.adorsys.ledgers.deposit.api.domain.AccountUsageBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.db.domain.AccountReference;
import de.adorsys.ledgers.deposit.db.domain.AccountStatus;
import de.adorsys.ledgers.deposit.db.domain.AccountType;
import de.adorsys.ledgers.deposit.db.domain.AccountUsage;
import de.adorsys.ledgers.deposit.db.domain.DepositAccount;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-01-17T16:25:57+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class DepositAccountMapperImpl implements DepositAccountMapper {

    @Override
    public DepositAccountBO toDepositAccountBO(DepositAccount depositAccount) {
        if ( depositAccount == null ) {
            return null;
        }

        DepositAccountBO depositAccountBO = new DepositAccountBO();

        depositAccountBO.setId( depositAccount.getId() );
        depositAccountBO.setIban( depositAccount.getIban() );
        depositAccountBO.setMsisdn( depositAccount.getMsisdn() );
        if ( depositAccount.getCurrency() != null ) {
            depositAccountBO.setCurrency( Currency.getInstance( depositAccount.getCurrency() ) );
        }
        depositAccountBO.setName( depositAccount.getName() );
        depositAccountBO.setProduct( depositAccount.getProduct() );
        depositAccountBO.setAccountType( accountTypeToAccountTypeBO( depositAccount.getAccountType() ) );
        depositAccountBO.setAccountStatus( accountStatusToAccountStatusBO( depositAccount.getAccountStatus() ) );
        depositAccountBO.setBic( depositAccount.getBic() );
        depositAccountBO.setLinkedAccounts( depositAccount.getLinkedAccounts() );
        depositAccountBO.setUsageType( accountUsageToAccountUsageBO( depositAccount.getUsageType() ) );
        depositAccountBO.setDetails( depositAccount.getDetails() );

        return depositAccountBO;
    }

    @Override
    public List<DepositAccountBO> toDepositAccountListBO(List<DepositAccount> list) {
        if ( list == null ) {
            return null;
        }

        List<DepositAccountBO> list1 = new ArrayList<DepositAccountBO>( list.size() );
        for ( DepositAccount depositAccount : list ) {
            list1.add( toDepositAccountBO( depositAccount ) );
        }

        return list1;
    }

    @Override
    public DepositAccount toDepositAccount(DepositAccountBO depositAccount) {
        if ( depositAccount == null ) {
            return null;
        }

        DepositAccount depositAccount1 = new DepositAccount();

        depositAccount1.setId( depositAccount.getId() );
        depositAccount1.setIban( depositAccount.getIban() );
        depositAccount1.setMsisdn( depositAccount.getMsisdn() );
        if ( depositAccount.getCurrency() != null ) {
            depositAccount1.setCurrency( depositAccount.getCurrency().getCurrencyCode() );
        }
        depositAccount1.setName( depositAccount.getName() );
        depositAccount1.setProduct( depositAccount.getProduct() );
        depositAccount1.setAccountType( accountTypeBOToAccountType( depositAccount.getAccountType() ) );
        depositAccount1.setAccountStatus( accountStatusBOToAccountStatus( depositAccount.getAccountStatus() ) );
        depositAccount1.setBic( depositAccount.getBic() );
        depositAccount1.setLinkedAccounts( depositAccount.getLinkedAccounts() );
        depositAccount1.setUsageType( accountUsageBOToAccountUsage( depositAccount.getUsageType() ) );
        depositAccount1.setDetails( depositAccount.getDetails() );

        return depositAccount1;
    }

    @Override
    public AccountReferenceBO toAccountReferenceBO(DepositAccount depositAccount) {
        if ( depositAccount == null ) {
            return null;
        }

        AccountReferenceBO accountReferenceBO = new AccountReferenceBO();

        accountReferenceBO.setIban( depositAccount.getIban() );
        accountReferenceBO.setMsisdn( depositAccount.getMsisdn() );
        if ( depositAccount.getCurrency() != null ) {
            accountReferenceBO.setCurrency( Currency.getInstance( depositAccount.getCurrency() ) );
        }

        return accountReferenceBO;
    }

    @Override
    public AccountReference toAccountReference(AccountReferenceBO reference) {
        if ( reference == null ) {
            return null;
        }

        AccountReference accountReference = new AccountReference();

        accountReference.setIban( reference.getIban() );
        accountReference.setBban( reference.getBban() );
        accountReference.setPan( reference.getPan() );
        accountReference.setMaskedPan( reference.getMaskedPan() );
        accountReference.setMsisdn( reference.getMsisdn() );
        if ( reference.getCurrency() != null ) {
            accountReference.setCurrency( reference.getCurrency().getCurrencyCode() );
        }

        return accountReference;
    }

    protected AccountTypeBO accountTypeToAccountTypeBO(AccountType accountType) {
        if ( accountType == null ) {
            return null;
        }

        AccountTypeBO accountTypeBO;

        switch ( accountType ) {
            case CACC: accountTypeBO = AccountTypeBO.CACC;
            break;
            case CASH: accountTypeBO = AccountTypeBO.CASH;
            break;
            case CHAR: accountTypeBO = AccountTypeBO.CHAR;
            break;
            case CISH: accountTypeBO = AccountTypeBO.CISH;
            break;
            case COMM: accountTypeBO = AccountTypeBO.COMM;
            break;
            case CPAC: accountTypeBO = AccountTypeBO.CPAC;
            break;
            case LLSV: accountTypeBO = AccountTypeBO.LLSV;
            break;
            case LOAN: accountTypeBO = AccountTypeBO.LOAN;
            break;
            case MGLD: accountTypeBO = AccountTypeBO.MGLD;
            break;
            case MOMA: accountTypeBO = AccountTypeBO.MOMA;
            break;
            case NREX: accountTypeBO = AccountTypeBO.NREX;
            break;
            case ODFT: accountTypeBO = AccountTypeBO.ODFT;
            break;
            case ONDP: accountTypeBO = AccountTypeBO.ONDP;
            break;
            case OTHR: accountTypeBO = AccountTypeBO.OTHR;
            break;
            case SACC: accountTypeBO = AccountTypeBO.SACC;
            break;
            case SLRY: accountTypeBO = AccountTypeBO.SLRY;
            break;
            case SVGS: accountTypeBO = AccountTypeBO.SVGS;
            break;
            case TAXE: accountTypeBO = AccountTypeBO.TAXE;
            break;
            case TRAN: accountTypeBO = AccountTypeBO.TRAN;
            break;
            case TRAS: accountTypeBO = AccountTypeBO.TRAS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountType );
        }

        return accountTypeBO;
    }

    protected AccountStatusBO accountStatusToAccountStatusBO(AccountStatus accountStatus) {
        if ( accountStatus == null ) {
            return null;
        }

        AccountStatusBO accountStatusBO;

        switch ( accountStatus ) {
            case ENABLED: accountStatusBO = AccountStatusBO.ENABLED;
            break;
            case DELETED: accountStatusBO = AccountStatusBO.DELETED;
            break;
            case BLOCKED: accountStatusBO = AccountStatusBO.BLOCKED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountStatus );
        }

        return accountStatusBO;
    }

    protected AccountUsageBO accountUsageToAccountUsageBO(AccountUsage accountUsage) {
        if ( accountUsage == null ) {
            return null;
        }

        AccountUsageBO accountUsageBO;

        switch ( accountUsage ) {
            case PRIV: accountUsageBO = AccountUsageBO.PRIV;
            break;
            case ORGA: accountUsageBO = AccountUsageBO.ORGA;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountUsage );
        }

        return accountUsageBO;
    }

    protected AccountType accountTypeBOToAccountType(AccountTypeBO accountTypeBO) {
        if ( accountTypeBO == null ) {
            return null;
        }

        AccountType accountType;

        switch ( accountTypeBO ) {
            case CACC: accountType = AccountType.CACC;
            break;
            case CASH: accountType = AccountType.CASH;
            break;
            case CHAR: accountType = AccountType.CHAR;
            break;
            case CISH: accountType = AccountType.CISH;
            break;
            case COMM: accountType = AccountType.COMM;
            break;
            case CPAC: accountType = AccountType.CPAC;
            break;
            case LLSV: accountType = AccountType.LLSV;
            break;
            case LOAN: accountType = AccountType.LOAN;
            break;
            case MGLD: accountType = AccountType.MGLD;
            break;
            case MOMA: accountType = AccountType.MOMA;
            break;
            case NREX: accountType = AccountType.NREX;
            break;
            case ODFT: accountType = AccountType.ODFT;
            break;
            case ONDP: accountType = AccountType.ONDP;
            break;
            case OTHR: accountType = AccountType.OTHR;
            break;
            case SACC: accountType = AccountType.SACC;
            break;
            case SLRY: accountType = AccountType.SLRY;
            break;
            case SVGS: accountType = AccountType.SVGS;
            break;
            case TAXE: accountType = AccountType.TAXE;
            break;
            case TRAN: accountType = AccountType.TRAN;
            break;
            case TRAS: accountType = AccountType.TRAS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountTypeBO );
        }

        return accountType;
    }

    protected AccountStatus accountStatusBOToAccountStatus(AccountStatusBO accountStatusBO) {
        if ( accountStatusBO == null ) {
            return null;
        }

        AccountStatus accountStatus;

        switch ( accountStatusBO ) {
            case ENABLED: accountStatus = AccountStatus.ENABLED;
            break;
            case DELETED: accountStatus = AccountStatus.DELETED;
            break;
            case BLOCKED: accountStatus = AccountStatus.BLOCKED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountStatusBO );
        }

        return accountStatus;
    }

    protected AccountUsage accountUsageBOToAccountUsage(AccountUsageBO accountUsageBO) {
        if ( accountUsageBO == null ) {
            return null;
        }

        AccountUsage accountUsage;

        switch ( accountUsageBO ) {
            case PRIV: accountUsage = AccountUsage.PRIV;
            break;
            case ORGA: accountUsage = AccountUsage.ORGA;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountUsageBO );
        }

        return accountUsage;
    }
}
