/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.mappers;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.ExchangeRateBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentOrderDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.db.domain.Payment;
import de.adorsys.ledgers.deposit.db.domain.PaymentTarget;
import de.adorsys.ledgers.deposit.db.domain.TransactionStatus;
import de.adorsys.ledgers.util.Ids;
import java.time.LocalDate;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public interface PaymentMapper {
    @Mappings(value={@Mapping(target="nextScheduledExecution", ignore=true), @Mapping(target="executedDate", ignore=true)})
    public Payment toPayment(PaymentBO var1);

    public PaymentBO toPaymentBO(Payment var1);

    public TransactionStatus toTransactionStatus(TransactionStatusBO var1);

    @Mapping(ignore=true, target="payment")
    public PaymentTargetBO toPaymentTargetBO(PaymentTarget var1);

    public PaymentOrderDetailsBO toPaymentOrder(PaymentBO var1);

    @Mappings(value={@Mapping(source="id", target="transactionId"), @Mapping(source="paymentTarget.endToEndIdentification", target="endToEndId"), @Mapping(source="postingTime", target="bookingDate"), @Mapping(source="postingTime", target="valueDate"), @Mapping(source="paymentTarget.instructedAmount", target="transactionAmount"), @Mapping(source="paymentTarget.payment.debtorAccount", target="debtorAccount"), @Mapping(source="paymentTarget.payment.paymentId", target="paymentOrderId"), @Mapping(source="paymentTarget.payment.paymentType", target="paymentType"), @Mapping(source="paymentTarget.payment.paymentProduct", target="paymentProduct"), @Mapping(source="rate", target="exchangeRate")})
    public PaymentTargetDetailsBO toPaymentTargetDetails(String var1, PaymentTargetBO var2, LocalDate var3, List<ExchangeRateBO> var4);

    @Mappings(value={@Mapping(source="amount", target="transactionAmount"), @Mapping(source="postingTime", target="valueDate"), @Mapping(source="postingTime", target="bookingDate"), @Mapping(source="id", target="transactionId"), @Mapping(source="payment.paymentId", target="paymentOrderId"), @Mapping(source="payment.paymentProduct", target="paymentProduct"), @Mapping(constant="multiple", target="creditorAgent"), @Mapping(constant="multiple", target="creditorName"), @Mapping(source="rate", target="exchangeRate")})
    public PaymentTargetDetailsBO toPaymentTargetDetailsBatch(String var1, PaymentBO var2, AmountBO var3, LocalDate var4, List<ExchangeRateBO> var5);

    @Mappings(value={@Mapping(target="transactionId", source="postingLineId"), @Mapping(target="endToEndId", source="postingLineId"), @Mapping(target="bookingDate", source="postingDate"), @Mapping(target="valueDate", source="postingDate"), @Mapping(target="transactionAmount", source="amount")})
    public TransactionDetailsBO toDepositTransactionDetails(AmountBO var1, AccountReferenceBO var2, LocalDate var3, String var4);

    default public String id() {
        return Ids.id();
    }

    public List<PaymentBO> toPaymentBOList(List<Payment> var1);
}

