/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.FundsConfirmationRequestBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountTransactionService;
import de.adorsys.ledgers.deposit.api.service.impl.ExecutionTimeHolder;
import de.adorsys.ledgers.deposit.api.service.mappers.PaymentMapper;
import de.adorsys.ledgers.deposit.db.domain.FrequencyCode;
import de.adorsys.ledgers.deposit.db.domain.Payment;
import de.adorsys.ledgers.deposit.db.domain.PaymentType;
import de.adorsys.ledgers.deposit.db.domain.TransactionStatus;
import de.adorsys.ledgers.deposit.db.repository.PaymentRepository;
import de.adorsys.ledgers.util.exception.DepositErrorCode;
import de.adorsys.ledgers.util.exception.DepositModuleException;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Currency;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.jdk8.LocalDateCalculator;
import net.objectlab.kit.datecalc.jdk8.LocalDateKitCalculatorsFactory;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import pro.javatar.commons.reader.YamlReader;

@Service
public class PaymentExecutionService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PaymentExecutionService.class);
    private static final String CALENDAR_NAME = "LEDGERS";
    private static final String PRECEDING = "preceding";
    private static final String FOLLOWING = "following";
    private final PaymentRepository paymentRepository;
    private final DepositAccountTransactionService txService;
    private final DepositAccountService accountService;
    private final PaymentMapper paymentMapper = (PaymentMapper)Mappers.getMapper(PaymentMapper.class);

    public void afterPropertiesSet() {
        DefaultHolidayCalendar calendar = new DefaultHolidayCalendar(new HashSet<LocalDate>(PaymentExecutionService.readHolidays()));
        LocalDateKitCalculatorsFactory.getDefaultInstance().registerHolidays("DE", (HolidayCalendar)calendar);
    }

    public TransactionStatusBO executePayment(Payment payment, String userName) {
        PaymentBO paymentBO = this.paymentMapper.toPaymentBO(payment);
        AmountBO amountToVerify = this.calculateTotalPaymentAmount(paymentBO);
        boolean confirmationOfFunds = this.accountService.confirmationOfFunds(new FundsConfirmationRequestBO(null, paymentBO.getDebtorAccount(), amountToVerify, null, null));
        if (!confirmationOfFunds) {
            this.updatePaymentStatus(payment, TransactionStatus.RJCT);
            log.info("Scheduler couldn't execute payment : {}. Insufficient funds to complete the operation", (Object)payment.getTransactionStatus());
            return TransactionStatusBO.RJCT;
        }
        LocalDateTime executionTime = LocalDateTime.now();
        this.txService.bookPayment(paymentBO, executionTime, userName);
        payment.setExecutedDate(executionTime);
        if (EnumSet.of(PaymentType.SINGLE, PaymentType.BULK).contains(payment.getPaymentType())) {
            return this.finalizePaymentStatus(payment);
        }
        return payment.getFrequency().equals((Object)FrequencyCode.DAILY) ? this.checkDailyPayment(payment, userName) : this.schedulePayment(payment);
    }

    public TransactionStatusBO schedulePayment(Payment payment) {
        LocalDate executionDate = this.calculateExecutionDate(payment);
        TransactionStatus status = executionDate == null ? this.paymentMapper.toTransactionStatus(this.finalizePaymentStatus(payment)) : TransactionStatus.ACSP;
        payment.setTransactionStatus(status);
        LocalDateTime executionDateTime = null;
        if (executionDate != null) {
            LocalTime executionTime = payment.getRequestedExecutionTime() == null ? LocalTime.MIN : payment.getRequestedExecutionTime();
            executionDateTime = LocalDateTime.of(executionDate, executionTime);
        }
        payment.setNextScheduledExecution(executionDateTime);
        Payment savedPayment = (Payment)this.paymentRepository.save((Object)payment);
        return TransactionStatusBO.valueOf((String)savedPayment.getTransactionStatus().name());
    }

    public AmountBO calculateTotalPaymentAmount(PaymentBO payment) {
        return payment.getTargets().stream().map(PaymentTargetBO::getInstructedAmount).reduce((left, right) -> new AmountBO(Currency.getInstance("EUR"), left.getAmount().add(right.getAmount()))).orElseThrow(() -> DepositModuleException.builder().errorCode(DepositErrorCode.PAYMENT_PROCESSING_FAILURE).devMsg(String.format("Could not calculate total amount for payment: %s.", payment.getPaymentId())).build());
    }

    private TransactionStatusBO finalizePaymentStatus(Payment payment) {
        return payment.getTargets().stream().map(t -> this.accountService.getOptionalAccountByIbanAndCurrency(t.getCreditorAccount().getIban(), Currency.getInstance(t.getCreditorAccount().getCurrency()))).allMatch(Optional::isPresent) ? this.updatePaymentStatus(payment, TransactionStatus.ACCC) : this.updatePaymentStatus(payment, TransactionStatus.ACSC);
    }

    private TransactionStatusBO updatePaymentStatus(Payment payment, TransactionStatus status) {
        payment.setTransactionStatus(status);
        payment.setNextScheduledExecution(null);
        this.paymentRepository.save((Object)payment);
        return TransactionStatusBO.valueOf((String)status.name());
    }

    private TransactionStatusBO checkDailyPayment(Payment payment, String userName) {
        return payment.getExecutionRule().equals(PRECEDING) ? this.precedingExecution(payment, userName) : this.followingExecution(payment, userName);
    }

    private TransactionStatusBO followingExecution(Payment payment, String userName) {
        if (this.dateCalculator(PRECEDING, LocalDate.now()).isNonWorkingDay((Object)LocalDate.now().minusDays(1L)) && LocalDate.now().isAfter(payment.getStartDate())) {
            LocalDate prevBusinessDay = (LocalDate)this.dateCalculator(PRECEDING, LocalDate.now().minusDays(1L)).getCurrentBusinessDate();
            IntStream.range(prevBusinessDay.getDayOfMonth(), LocalDate.now().getDayOfMonth() - 1).forEach(i -> this.txService.bookPayment(this.paymentMapper.toPaymentBO(payment), LocalDateTime.now(), userName));
        }
        return this.schedulePayment(payment);
    }

    private TransactionStatusBO precedingExecution(Payment payment, String userName) {
        LocalDate nextBusinessDay = (LocalDate)this.dateCalculator(FOLLOWING, LocalDate.now().plusDays(1L)).getCurrentBusinessDate();
        if (this.dateCalculator(FOLLOWING, LocalDate.now()).isNonWorkingDay((Object)LocalDate.now().plusDays(1L))) {
            IntStream.range(LocalDate.now().getDayOfMonth() + 1, nextBusinessDay.getDayOfMonth()).forEach(i -> this.txService.bookPayment(this.paymentMapper.toPaymentBO(payment), LocalDateTime.now(), userName));
        }
        payment.setExecutedDate(LocalDateTime.of(nextBusinessDay.minusDays(1L), LocalTime.MIN));
        return this.schedulePayment(payment);
    }

    private LocalDate calculateExecutionDate(Payment payment) {
        LocalDate date = payment.getPaymentType() == PaymentType.PERIODIC ? this.calculateForPeriodicPmt(payment) : this.calculateForRegularPmt(payment);
        return payment.isLastExecuted(date) ? null : (LocalDate)this.dateCalculator(payment.getExecutionRule(), date).getCurrentBusinessDate();
    }

    private LocalDate calculateForRegularPmt(Payment payment) {
        return payment.getRequestedExecutionDate() != null && !payment.getRequestedExecutionDate().isBefore(LocalDate.now()) ? payment.getRequestedExecutionDate() : LocalDate.now();
    }

    private LocalDate calculateForPeriodicPmt(Payment payment) {
        return payment.getExecutedDate() == null ? PaymentExecutionService.nextDayOfExecution(payment) : ExecutionTimeHolder.getExecutionDate(payment);
    }

    private static LocalDate nextDayOfExecution(Payment payment) {
        if (payment.getStartDate().isAfter(payment.getStartDate().withDayOfMonth(payment.getDayOfExecution()))) {
            return payment.getStartDate();
        }
        return payment.getStartDate().withDayOfMonth(payment.getDayOfExecution());
    }

    private DateCalculator<LocalDate> dateCalculator(String executionRule, LocalDate date) {
        LocalDateCalculator calc = PRECEDING.equals(executionRule) ? LocalDateKitCalculatorsFactory.backwardCalculator((String)CALENDAR_NAME) : LocalDateKitCalculatorsFactory.forwardCalculator((String)CALENDAR_NAME);
        return calc.setStartDate((Object)date);
    }

    private static List<LocalDate> readHolidays() {
        try {
            return YamlReader.getInstance().getListFromFile("holidays.yml", LocalDate.class);
        }
        catch (IOException e) {
            throw DepositModuleException.builder().errorCode(DepositErrorCode.PAYMENT_PROCESSING_FAILURE).devMsg(e.getMessage()).build();
        }
    }

    public PaymentExecutionService(PaymentRepository paymentRepository, DepositAccountTransactionService txService, DepositAccountService accountService) {
        this.paymentRepository = paymentRepository;
        this.txService = txService;
        this.accountService = accountService;
    }
}

