package de.adorsys.ledgers.deposit.api.service.mappers;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AddressBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.FrequencyCodeBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentOrderDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentProductBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.db.domain.AccountReference;
import de.adorsys.ledgers.deposit.db.domain.Address;
import de.adorsys.ledgers.deposit.db.domain.Amount;
import de.adorsys.ledgers.deposit.db.domain.FrequencyCode;
import de.adorsys.ledgers.deposit.db.domain.Payment;
import de.adorsys.ledgers.deposit.db.domain.PaymentProduct;
import de.adorsys.ledgers.deposit.db.domain.PaymentTarget;
import de.adorsys.ledgers.deposit.db.domain.PaymentType;
import de.adorsys.ledgers.deposit.db.domain.TransactionStatus;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-06-21T13:57:37+0000",
    comments = "version: 1.2.0.Final, compiler: javac, environment: Java 1.8.0_151 (Oracle Corporation)"
)
@Component
public class PaymentMapperImpl implements PaymentMapper {

    @Autowired
    private CurrencyMapper currencyMapper;

    @Override
    public Payment toPayment(PaymentBO payment) {
        if ( payment == null ) {
            return null;
        }

        Payment payment1 = new Payment();

        payment1.setPaymentId( payment.getPaymentId() );
        payment1.setBatchBookingPreferred( payment.getBatchBookingPreferred() );
        payment1.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        payment1.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        payment1.setPaymentType( paymentTypeBOToPaymentType( payment.getPaymentType() ) );
        payment1.setStartDate( payment.getStartDate() );
        payment1.setEndDate( payment.getEndDate() );
        payment1.setExecutionRule( payment.getExecutionRule() );
        payment1.setFrequency( frequencyCodeBOToFrequencyCode( payment.getFrequency() ) );
        payment1.setDayOfExecution( payment.getDayOfExecution() );
        payment1.setDebtorAccount( accountReferenceBOToAccountReference( payment.getDebtorAccount() ) );
        payment1.setTransactionStatus( transactionStatusBOToTransactionStatus( payment.getTransactionStatus() ) );
        payment1.setTargets( paymentTargetBOListToPaymentTargetList( payment.getTargets() ) );

        return payment1;
    }

    @Override
    public PaymentBO toPaymentBO(Payment payment) {
        if ( payment == null ) {
            return null;
        }

        PaymentBO paymentBO = new PaymentBO();

        paymentBO.setPaymentId( payment.getPaymentId() );
        paymentBO.setBatchBookingPreferred( payment.getBatchBookingPreferred() );
        paymentBO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        paymentBO.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        paymentBO.setPaymentType( paymentTypeToPaymentTypeBO( payment.getPaymentType() ) );
        paymentBO.setStartDate( payment.getStartDate() );
        paymentBO.setEndDate( payment.getEndDate() );
        paymentBO.setExecutionRule( payment.getExecutionRule() );
        paymentBO.setFrequency( frequencyCodeToFrequencyCodeBO( payment.getFrequency() ) );
        paymentBO.setDayOfExecution( payment.getDayOfExecution() );
        paymentBO.setDebtorAccount( accountReferenceToAccountReferenceBO( payment.getDebtorAccount() ) );
        paymentBO.setTransactionStatus( transactionStatusToTransactionStatusBO( payment.getTransactionStatus() ) );
        paymentBO.setTargets( paymentTargetListToPaymentTargetBOList( payment.getTargets() ) );

        return paymentBO;
    }

    @Override
    public PaymentTargetBO toPaymentTargetBO(PaymentTarget target) {
        if ( target == null ) {
            return null;
        }

        PaymentTargetBO paymentTargetBO = new PaymentTargetBO();

        paymentTargetBO.setPaymentId( target.getPaymentId() );
        paymentTargetBO.setEndToEndIdentification( target.getEndToEndIdentification() );
        paymentTargetBO.setInstructedAmount( amountToAmountBO( target.getInstructedAmount() ) );
        paymentTargetBO.setCreditorAccount( accountReferenceToAccountReferenceBO( target.getCreditorAccount() ) );
        paymentTargetBO.setCreditorAgent( target.getCreditorAgent() );
        paymentTargetBO.setCreditorName( target.getCreditorName() );
        paymentTargetBO.setCreditorAddress( addressToAddressBO( target.getCreditorAddress() ) );
        paymentTargetBO.setRemittanceInformationUnstructured( target.getRemittanceInformationUnstructured() );
        paymentTargetBO.setPaymentProduct( paymentProductToPaymentProductBO( target.getPaymentProduct() ) );

        return paymentTargetBO;
    }

    @Override
    public PaymentOrderDetailsBO toPaymentOrder(PaymentBO payment) {
        if ( payment == null ) {
            return null;
        }

        PaymentOrderDetailsBO paymentOrderDetailsBO = new PaymentOrderDetailsBO();

        paymentOrderDetailsBO.setPaymentId( payment.getPaymentId() );
        paymentOrderDetailsBO.setBatchBookingPreferred( payment.getBatchBookingPreferred() );
        paymentOrderDetailsBO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        paymentOrderDetailsBO.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        paymentOrderDetailsBO.setPaymentType( payment.getPaymentType() );
        paymentOrderDetailsBO.setStartDate( payment.getStartDate() );
        paymentOrderDetailsBO.setEndDate( payment.getEndDate() );
        paymentOrderDetailsBO.setExecutionRule( payment.getExecutionRule() );
        paymentOrderDetailsBO.setFrequency( payment.getFrequency() );
        paymentOrderDetailsBO.setDayOfExecution( payment.getDayOfExecution() );
        paymentOrderDetailsBO.setDebtorAccount( payment.getDebtorAccount() );
        paymentOrderDetailsBO.setTransactionStatus( payment.getTransactionStatus() );

        return paymentOrderDetailsBO;
    }

    @Override
    public PaymentTargetDetailsBO toPaymentTargetDetails(String id, PaymentTargetBO paymentTarget, LocalDate postingTime) {
        if ( id == null && paymentTarget == null && postingTime == null ) {
            return null;
        }

        PaymentTargetDetailsBO paymentTargetDetailsBO = new PaymentTargetDetailsBO();

        if ( id != null ) {
            paymentTargetDetailsBO.setTransactionId( id );
        }
        if ( paymentTarget != null ) {
            AccountReferenceBO debtorAccount = paymentTargetPaymentDebtorAccount( paymentTarget );
            if ( debtorAccount != null ) {
                paymentTargetDetailsBO.setDebtorAccount( debtorAccount );
            }
            paymentTargetDetailsBO.setTransactionAmount( paymentTarget.getInstructedAmount() );
            String paymentId = paymentTargetPaymentPaymentId( paymentTarget );
            if ( paymentId != null ) {
                paymentTargetDetailsBO.setPaymentOrderId( paymentId );
            }
            paymentTargetDetailsBO.setEndToEndId( paymentTarget.getEndToEndIdentification() );
            PaymentTypeBO paymentType = paymentTargetPaymentPaymentType( paymentTarget );
            if ( paymentType != null ) {
                paymentTargetDetailsBO.setPaymentType( paymentType );
            }
            paymentTargetDetailsBO.setCreditorName( paymentTarget.getCreditorName() );
            paymentTargetDetailsBO.setCreditorAccount( paymentTarget.getCreditorAccount() );
            paymentTargetDetailsBO.setRemittanceInformationUnstructured( paymentTarget.getRemittanceInformationUnstructured() );
            paymentTargetDetailsBO.setCreditorAddress( paymentTarget.getCreditorAddress() );
            paymentTargetDetailsBO.setPaymentProduct( paymentTarget.getPaymentProduct() );
            paymentTargetDetailsBO.setCreditorAgent( paymentTarget.getCreditorAgent() );
        }
        if ( postingTime != null ) {
            paymentTargetDetailsBO.setBookingDate( postingTime );
            paymentTargetDetailsBO.setValueDate( postingTime );
        }

        return paymentTargetDetailsBO;
    }

    @Override
    public PaymentTargetDetailsBO toPaymentTargetDetailsBatch(String id, PaymentBO payment, AmountBO amount, LocalDate postingTime) {
        if ( id == null && payment == null && amount == null && postingTime == null ) {
            return null;
        }

        PaymentTargetDetailsBO paymentTargetDetailsBO = new PaymentTargetDetailsBO();

        if ( id != null ) {
            paymentTargetDetailsBO.setTransactionId( id );
        }
        if ( payment != null ) {
            paymentTargetDetailsBO.setPaymentOrderId( payment.getPaymentId() );
            paymentTargetDetailsBO.setDebtorAccount( payment.getDebtorAccount() );
            paymentTargetDetailsBO.setPaymentType( payment.getPaymentType() );
            paymentTargetDetailsBO.setTransactionStatus( payment.getTransactionStatus() );
        }
        if ( amount != null ) {
            paymentTargetDetailsBO.setTransactionAmount( amount );
        }
        if ( postingTime != null ) {
            paymentTargetDetailsBO.setBookingDate( postingTime );
            paymentTargetDetailsBO.setValueDate( postingTime );
        }
        paymentTargetDetailsBO.setCreditorName( "multiple" );
        paymentTargetDetailsBO.setCreditorAgent( "multiple" );

        return paymentTargetDetailsBO;
    }

    protected PaymentType paymentTypeBOToPaymentType(PaymentTypeBO paymentTypeBO) {
        if ( paymentTypeBO == null ) {
            return null;
        }

        PaymentType paymentType;

        switch ( paymentTypeBO ) {
            case SINGLE: paymentType = PaymentType.SINGLE;
            break;
            case BULK: paymentType = PaymentType.BULK;
            break;
            case PERIODIC: paymentType = PaymentType.PERIODIC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + paymentTypeBO );
        }

        return paymentType;
    }

    protected FrequencyCode frequencyCodeBOToFrequencyCode(FrequencyCodeBO frequencyCodeBO) {
        if ( frequencyCodeBO == null ) {
            return null;
        }

        FrequencyCode frequencyCode;

        switch ( frequencyCodeBO ) {
            case DAILY: frequencyCode = FrequencyCode.DAILY;
            break;
            case WEEKLY: frequencyCode = FrequencyCode.WEEKLY;
            break;
            case EVERYTWOWEEKS: frequencyCode = FrequencyCode.EVERYTWOWEEKS;
            break;
            case MONTHLY: frequencyCode = FrequencyCode.MONTHLY;
            break;
            case EVERYTWOMONTHS: frequencyCode = FrequencyCode.EVERYTWOMONTHS;
            break;
            case QUARTERLY: frequencyCode = FrequencyCode.QUARTERLY;
            break;
            case SEMIANNUAL: frequencyCode = FrequencyCode.SEMIANNUAL;
            break;
            case ANNUAL: frequencyCode = FrequencyCode.ANNUAL;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCodeBO );
        }

        return frequencyCode;
    }

    protected AccountReference accountReferenceBOToAccountReference(AccountReferenceBO accountReferenceBO) {
        if ( accountReferenceBO == null ) {
            return null;
        }

        AccountReference accountReference = new AccountReference();

        accountReference.setIban( accountReferenceBO.getIban() );
        accountReference.setBban( accountReferenceBO.getBban() );
        accountReference.setPan( accountReferenceBO.getPan() );
        accountReference.setMaskedPan( accountReferenceBO.getMaskedPan() );
        accountReference.setMsisdn( accountReferenceBO.getMsisdn() );
        accountReference.setCurrency( currencyMapper.currencyToString( accountReferenceBO.getCurrency() ) );

        return accountReference;
    }

    protected TransactionStatus transactionStatusBOToTransactionStatus(TransactionStatusBO transactionStatusBO) {
        if ( transactionStatusBO == null ) {
            return null;
        }

        TransactionStatus transactionStatus;

        switch ( transactionStatusBO ) {
            case ACCC: transactionStatus = TransactionStatus.ACCC;
            break;
            case ACCP: transactionStatus = TransactionStatus.ACCP;
            break;
            case ACSC: transactionStatus = TransactionStatus.ACSC;
            break;
            case ACSP: transactionStatus = TransactionStatus.ACSP;
            break;
            case ACTC: transactionStatus = TransactionStatus.ACTC;
            break;
            case ACWC: transactionStatus = TransactionStatus.ACWC;
            break;
            case ACWP: transactionStatus = TransactionStatus.ACWP;
            break;
            case RCVD: transactionStatus = TransactionStatus.RCVD;
            break;
            case PDNG: transactionStatus = TransactionStatus.PDNG;
            break;
            case RJCT: transactionStatus = TransactionStatus.RJCT;
            break;
            case CANC: transactionStatus = TransactionStatus.CANC;
            break;
            case ACFC: transactionStatus = TransactionStatus.ACFC;
            break;
            case PATC: transactionStatus = TransactionStatus.PATC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + transactionStatusBO );
        }

        return transactionStatus;
    }

    protected Amount amountBOToAmount(AmountBO amountBO) {
        if ( amountBO == null ) {
            return null;
        }

        Amount amount = new Amount();

        amount.setAmount( amountBO.getAmount() );
        amount.setCurrency( currencyMapper.currencyToString( amountBO.getCurrency() ) );

        return amount;
    }

    protected Address addressBOToAddress(AddressBO addressBO) {
        if ( addressBO == null ) {
            return null;
        }

        Address address = new Address();

        address.setStreet( addressBO.getStreet() );
        address.setBuildingNumber( addressBO.getBuildingNumber() );
        address.setCity( addressBO.getCity() );
        address.setPostalCode( addressBO.getPostalCode() );
        address.setCountry( addressBO.getCountry() );

        return address;
    }

    protected PaymentProduct paymentProductBOToPaymentProduct(PaymentProductBO paymentProductBO) {
        if ( paymentProductBO == null ) {
            return null;
        }

        PaymentProduct paymentProduct;

        switch ( paymentProductBO ) {
            case SEPA: paymentProduct = PaymentProduct.SEPA;
            break;
            case INSTANT_SEPA: paymentProduct = PaymentProduct.INSTANT_SEPA;
            break;
            case TARGET2: paymentProduct = PaymentProduct.TARGET2;
            break;
            case CROSS_BORDER: paymentProduct = PaymentProduct.CROSS_BORDER;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + paymentProductBO );
        }

        return paymentProduct;
    }

    protected PaymentTarget paymentTargetBOToPaymentTarget(PaymentTargetBO paymentTargetBO) {
        if ( paymentTargetBO == null ) {
            return null;
        }

        PaymentTarget paymentTarget = new PaymentTarget();

        paymentTarget.setPaymentId( paymentTargetBO.getPaymentId() );
        paymentTarget.setEndToEndIdentification( paymentTargetBO.getEndToEndIdentification() );
        paymentTarget.setInstructedAmount( amountBOToAmount( paymentTargetBO.getInstructedAmount() ) );
        paymentTarget.setCreditorAccount( accountReferenceBOToAccountReference( paymentTargetBO.getCreditorAccount() ) );
        paymentTarget.setCreditorAgent( paymentTargetBO.getCreditorAgent() );
        paymentTarget.setCreditorName( paymentTargetBO.getCreditorName() );
        paymentTarget.setCreditorAddress( addressBOToAddress( paymentTargetBO.getCreditorAddress() ) );
        paymentTarget.setRemittanceInformationUnstructured( paymentTargetBO.getRemittanceInformationUnstructured() );
        paymentTarget.setPaymentProduct( paymentProductBOToPaymentProduct( paymentTargetBO.getPaymentProduct() ) );
        paymentTarget.setPayment( toPayment( paymentTargetBO.getPayment() ) );

        return paymentTarget;
    }

    protected List<PaymentTarget> paymentTargetBOListToPaymentTargetList(List<PaymentTargetBO> list) {
        if ( list == null ) {
            return null;
        }

        List<PaymentTarget> list1 = new ArrayList<PaymentTarget>( list.size() );
        for ( PaymentTargetBO paymentTargetBO : list ) {
            list1.add( paymentTargetBOToPaymentTarget( paymentTargetBO ) );
        }

        return list1;
    }

    protected PaymentTypeBO paymentTypeToPaymentTypeBO(PaymentType paymentType) {
        if ( paymentType == null ) {
            return null;
        }

        PaymentTypeBO paymentTypeBO;

        switch ( paymentType ) {
            case SINGLE: paymentTypeBO = PaymentTypeBO.SINGLE;
            break;
            case BULK: paymentTypeBO = PaymentTypeBO.BULK;
            break;
            case PERIODIC: paymentTypeBO = PaymentTypeBO.PERIODIC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + paymentType );
        }

        return paymentTypeBO;
    }

    protected FrequencyCodeBO frequencyCodeToFrequencyCodeBO(FrequencyCode frequencyCode) {
        if ( frequencyCode == null ) {
            return null;
        }

        FrequencyCodeBO frequencyCodeBO;

        switch ( frequencyCode ) {
            case DAILY: frequencyCodeBO = FrequencyCodeBO.DAILY;
            break;
            case WEEKLY: frequencyCodeBO = FrequencyCodeBO.WEEKLY;
            break;
            case EVERYTWOWEEKS: frequencyCodeBO = FrequencyCodeBO.EVERYTWOWEEKS;
            break;
            case MONTHLY: frequencyCodeBO = FrequencyCodeBO.MONTHLY;
            break;
            case EVERYTWOMONTHS: frequencyCodeBO = FrequencyCodeBO.EVERYTWOMONTHS;
            break;
            case QUARTERLY: frequencyCodeBO = FrequencyCodeBO.QUARTERLY;
            break;
            case SEMIANNUAL: frequencyCodeBO = FrequencyCodeBO.SEMIANNUAL;
            break;
            case ANNUAL: frequencyCodeBO = FrequencyCodeBO.ANNUAL;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCode );
        }

        return frequencyCodeBO;
    }

    protected AccountReferenceBO accountReferenceToAccountReferenceBO(AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        AccountReferenceBO accountReferenceBO = new AccountReferenceBO();

        accountReferenceBO.setIban( accountReference.getIban() );
        accountReferenceBO.setBban( accountReference.getBban() );
        accountReferenceBO.setPan( accountReference.getPan() );
        accountReferenceBO.setMaskedPan( accountReference.getMaskedPan() );
        accountReferenceBO.setMsisdn( accountReference.getMsisdn() );
        accountReferenceBO.setCurrency( currencyMapper.toCurrency( accountReference.getCurrency() ) );

        return accountReferenceBO;
    }

    protected TransactionStatusBO transactionStatusToTransactionStatusBO(TransactionStatus transactionStatus) {
        if ( transactionStatus == null ) {
            return null;
        }

        TransactionStatusBO transactionStatusBO;

        switch ( transactionStatus ) {
            case ACCC: transactionStatusBO = TransactionStatusBO.ACCC;
            break;
            case ACCP: transactionStatusBO = TransactionStatusBO.ACCP;
            break;
            case ACSC: transactionStatusBO = TransactionStatusBO.ACSC;
            break;
            case ACSP: transactionStatusBO = TransactionStatusBO.ACSP;
            break;
            case ACTC: transactionStatusBO = TransactionStatusBO.ACTC;
            break;
            case ACWC: transactionStatusBO = TransactionStatusBO.ACWC;
            break;
            case ACWP: transactionStatusBO = TransactionStatusBO.ACWP;
            break;
            case RCVD: transactionStatusBO = TransactionStatusBO.RCVD;
            break;
            case PDNG: transactionStatusBO = TransactionStatusBO.PDNG;
            break;
            case RJCT: transactionStatusBO = TransactionStatusBO.RJCT;
            break;
            case CANC: transactionStatusBO = TransactionStatusBO.CANC;
            break;
            case ACFC: transactionStatusBO = TransactionStatusBO.ACFC;
            break;
            case PATC: transactionStatusBO = TransactionStatusBO.PATC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + transactionStatus );
        }

        return transactionStatusBO;
    }

    protected List<PaymentTargetBO> paymentTargetListToPaymentTargetBOList(List<PaymentTarget> list) {
        if ( list == null ) {
            return null;
        }

        List<PaymentTargetBO> list1 = new ArrayList<PaymentTargetBO>( list.size() );
        for ( PaymentTarget paymentTarget : list ) {
            list1.add( toPaymentTargetBO( paymentTarget ) );
        }

        return list1;
    }

    protected AmountBO amountToAmountBO(Amount amount) {
        if ( amount == null ) {
            return null;
        }

        AmountBO amountBO = new AmountBO();

        amountBO.setCurrency( currencyMapper.toCurrency( amount.getCurrency() ) );
        amountBO.setAmount( amount.getAmount() );

        return amountBO;
    }

    protected AddressBO addressToAddressBO(Address address) {
        if ( address == null ) {
            return null;
        }

        AddressBO addressBO = new AddressBO();

        addressBO.setStreet( address.getStreet() );
        addressBO.setBuildingNumber( address.getBuildingNumber() );
        addressBO.setCity( address.getCity() );
        addressBO.setPostalCode( address.getPostalCode() );
        addressBO.setCountry( address.getCountry() );

        return addressBO;
    }

    protected PaymentProductBO paymentProductToPaymentProductBO(PaymentProduct paymentProduct) {
        if ( paymentProduct == null ) {
            return null;
        }

        PaymentProductBO paymentProductBO;

        switch ( paymentProduct ) {
            case SEPA: paymentProductBO = PaymentProductBO.SEPA;
            break;
            case INSTANT_SEPA: paymentProductBO = PaymentProductBO.INSTANT_SEPA;
            break;
            case TARGET2: paymentProductBO = PaymentProductBO.TARGET2;
            break;
            case CROSS_BORDER: paymentProductBO = PaymentProductBO.CROSS_BORDER;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + paymentProduct );
        }

        return paymentProductBO;
    }

    private AccountReferenceBO paymentTargetPaymentDebtorAccount(PaymentTargetBO paymentTargetBO) {
        if ( paymentTargetBO == null ) {
            return null;
        }
        PaymentBO payment = paymentTargetBO.getPayment();
        if ( payment == null ) {
            return null;
        }
        AccountReferenceBO debtorAccount = payment.getDebtorAccount();
        if ( debtorAccount == null ) {
            return null;
        }
        return debtorAccount;
    }

    private String paymentTargetPaymentPaymentId(PaymentTargetBO paymentTargetBO) {
        if ( paymentTargetBO == null ) {
            return null;
        }
        PaymentBO payment = paymentTargetBO.getPayment();
        if ( payment == null ) {
            return null;
        }
        String paymentId = payment.getPaymentId();
        if ( paymentId == null ) {
            return null;
        }
        return paymentId;
    }

    private PaymentTypeBO paymentTargetPaymentPaymentType(PaymentTargetBO paymentTargetBO) {
        if ( paymentTargetBO == null ) {
            return null;
        }
        PaymentBO payment = paymentTargetBO.getPayment();
        if ( payment == null ) {
            return null;
        }
        PaymentTypeBO paymentType = payment.getPaymentType();
        if ( paymentType == null ) {
            return null;
        }
        return paymentType;
    }
}
