/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountTransactionService;
import de.adorsys.ledgers.deposit.api.service.impl.ExecutionTimeHolder;
import de.adorsys.ledgers.deposit.db.domain.Payment;
import de.adorsys.ledgers.deposit.db.domain.PaymentType;
import de.adorsys.ledgers.deposit.db.domain.TransactionStatus;
import de.adorsys.ledgers.deposit.db.repository.PaymentRepository;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashSet;
import java.util.List;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.jdk8.LocalDateCalculator;
import net.objectlab.kit.datecalc.jdk8.LocalDateKitCalculatorsFactory;
import org.springframework.stereotype.Service;
import pro.javatar.commons.reader.YamlReader;

@Service
public class PaymentExecutionService {
    private static final String CALENDAR_NAME = "LEDGERS";
    private static final String PRECEDING = "preceeding";
    private final PaymentRepository paymentRepository;
    private final DepositAccountTransactionService txService;

    public PaymentExecutionService(PaymentRepository paymentRepository, DepositAccountTransactionService txService) {
        this.paymentRepository = paymentRepository;
        this.txService = txService;
        DefaultHolidayCalendar calendar = new DefaultHolidayCalendar(new HashSet<LocalDate>(PaymentExecutionService.readHolidays()));
        LocalDateKitCalculatorsFactory.getDefaultInstance().registerHolidays("DE", (HolidayCalendar)calendar);
    }

    public TransactionStatusBO executePayment(Payment payment, String userName) {
        LocalDateTime executionTime = LocalDateTime.now();
        this.txService.bookPayment(payment, executionTime, userName);
        payment.setExecutedDate(executionTime);
        if (payment.getPaymentType() == PaymentType.PERIODIC) {
            return this.schedulePayment(payment);
        }
        payment.setTransactionStatus(TransactionStatus.ACSC);
        payment.setNextScheduledExecution(null);
        Payment savedPayment = (Payment)this.paymentRepository.save((Object)payment);
        return TransactionStatusBO.valueOf((String)savedPayment.getTransactionStatus().name());
    }

    public TransactionStatusBO schedulePayment(Payment payment) {
        LocalDate executionDate = this.calculateExecutionDate(payment);
        TransactionStatus status = executionDate == null ? TransactionStatus.ACSC : TransactionStatus.ACSP;
        payment.setTransactionStatus(status);
        LocalDateTime executionDateTime = null;
        if (executionDate != null) {
            LocalTime executionTime = payment.getRequestedExecutionTime() == null ? LocalTime.MIN : payment.getRequestedExecutionTime();
            executionDateTime = LocalDateTime.of(executionDate, executionTime);
        }
        payment.setNextScheduledExecution(executionDateTime);
        Payment savedPayment = (Payment)this.paymentRepository.save((Object)payment);
        return TransactionStatusBO.valueOf((String)savedPayment.getTransactionStatus().name());
    }

    private LocalDate calculateExecutionDate(Payment payment) {
        LocalDate date = payment.getPaymentType() == PaymentType.PERIODIC ? this.calculateForPeriodicPmt(payment) : this.calculateForRegularPmt(payment);
        return payment.isLastExecuted(date) ? null : this.calculateBusinessDate(payment.getExecutionRule(), date);
    }

    private LocalDate calculateForRegularPmt(Payment payment) {
        return payment.getRequestedExecutionDate() != null && !payment.getRequestedExecutionDate().isBefore(LocalDate.now()) ? payment.getRequestedExecutionDate() : LocalDate.now();
    }

    private LocalDate calculateForPeriodicPmt(Payment payment) {
        return payment.getExecutedDate() == null ? payment.getStartDate() : ExecutionTimeHolder.getExecutionDate(payment);
    }

    private LocalDate calculateBusinessDate(String executionRule, LocalDate date) {
        LocalDateCalculator calc = PRECEDING.equals(executionRule) ? LocalDateKitCalculatorsFactory.backwardCalculator((String)CALENDAR_NAME) : LocalDateKitCalculatorsFactory.forwardCalculator((String)CALENDAR_NAME);
        calc.setStartDate((Object)date);
        return (LocalDate)calc.getCurrentBusinessDate();
    }

    private static List<LocalDate> readHolidays() {
        try {
            return YamlReader.getInstance().getListFromFile("holidays.yml", LocalDate.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

