/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceTypeBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.FundsConfirmationRequestBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.deposit.api.exception.DepositAccountNotFoundException;
import de.adorsys.ledgers.deposit.api.exception.DepositAccountUncheckedException;
import de.adorsys.ledgers.deposit.api.exception.TransactionNotFoundException;
import de.adorsys.ledgers.deposit.api.service.DepositAccountConfigService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.deposit.api.service.impl.AbstractServiceImpl;
import de.adorsys.ledgers.deposit.api.service.mappers.DepositAccountMapper;
import de.adorsys.ledgers.deposit.api.service.mappers.TransactionDetailsMapper;
import de.adorsys.ledgers.deposit.db.domain.DepositAccount;
import de.adorsys.ledgers.deposit.db.repository.DepositAccountRepository;
import de.adorsys.ledgers.postings.api.domain.AccountStmtBO;
import de.adorsys.ledgers.postings.api.domain.BalanceSideBO;
import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerBO;
import de.adorsys.ledgers.postings.api.domain.PostingBO;
import de.adorsys.ledgers.postings.api.domain.PostingLineBO;
import de.adorsys.ledgers.postings.api.domain.PostingTraceBO;
import de.adorsys.ledgers.postings.api.domain.PostingTypeBO;
import de.adorsys.ledgers.postings.api.exception.BaseLineException;
import de.adorsys.ledgers.postings.api.exception.DoubleEntryAccountingException;
import de.adorsys.ledgers.postings.api.exception.LedgerAccountNotFoundException;
import de.adorsys.ledgers.postings.api.exception.LedgerNotFoundException;
import de.adorsys.ledgers.postings.api.exception.PostingNotFoundException;
import de.adorsys.ledgers.postings.api.service.AccountStmtService;
import de.adorsys.ledgers.postings.api.service.LedgerService;
import de.adorsys.ledgers.postings.api.service.PostingService;
import de.adorsys.ledgers.util.Ids;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DepositAccountServiceImpl
extends AbstractServiceImpl
implements DepositAccountService {
    private static final Logger logger = LoggerFactory.getLogger(DepositAccountServiceImpl.class);
    private static final String msgIbanNF = "Accounts with iban %s not found";
    private final DepositAccountRepository depositAccountRepository;
    private final DepositAccountMapper depositAccountMapper;
    private final AccountStmtService accountStmtService;
    private final PostingService postingService;
    private final TransactionDetailsMapper transactionDetailsMapper;
    private final ObjectMapper objectMapper;

    public DepositAccountServiceImpl(DepositAccountConfigService depositAccountConfigService, LedgerService ledgerService, DepositAccountRepository depositAccountRepository, DepositAccountMapper depositAccountMapper, AccountStmtService accountStmtService, PostingService postingService, TransactionDetailsMapper transactionDetailsMapper, ObjectMapper objectMapper) {
        super(depositAccountConfigService, ledgerService);
        this.depositAccountRepository = depositAccountRepository;
        this.depositAccountMapper = depositAccountMapper;
        this.accountStmtService = accountStmtService;
        this.postingService = postingService;
        this.transactionDetailsMapper = transactionDetailsMapper;
        this.objectMapper = objectMapper;
    }

    public DepositAccountBO createDepositAccount(DepositAccountBO depositAccountBO, String userName) throws DepositAccountNotFoundException {
        DepositAccount da = this.createDepositAccountObj(depositAccountBO, userName);
        DepositAccount saved = (DepositAccount)this.depositAccountRepository.save((Object)da);
        return this.depositAccountMapper.toDepositAccountBO(saved);
    }

    public DepositAccountBO createDepositAccountForBranch(DepositAccountBO depositAccountBO, String userName, String branch) throws DepositAccountNotFoundException {
        DepositAccount da = this.createDepositAccountObj(depositAccountBO, userName);
        da.setBranch(branch);
        DepositAccount saved = (DepositAccount)this.depositAccountRepository.save((Object)da);
        return this.depositAccountMapper.toDepositAccountBO(saved);
    }

    public DepositAccountDetailsBO getDepositAccountByIban(String iban, LocalDateTime refTime, boolean withBalances) throws DepositAccountNotFoundException {
        List<DepositAccountBO> accounts = this.getDepositAccountsByIban(Collections.singletonList(iban));
        if (accounts.isEmpty()) {
            throw new DepositAccountNotFoundException(String.format(msgIbanNF, iban));
        }
        DepositAccountBO account = accounts.iterator().next();
        return new DepositAccountDetailsBO(account, this.getBalancesList(account, withBalances, refTime));
    }

    public List<DepositAccountDetailsBO> getDepositAccountsByIban(List<String> ibans, LocalDateTime refTime, boolean withBalances) throws DepositAccountNotFoundException {
        ArrayList<DepositAccountDetailsBO> result = new ArrayList<DepositAccountDetailsBO>();
        for (String iban : ibans) {
            result.add(this.getDepositAccountByIban(iban, refTime, withBalances));
        }
        return result;
    }

    public DepositAccountDetailsBO getDepositAccountById(String accountId, LocalDateTime refTime, boolean withBalances) throws DepositAccountNotFoundException {
        DepositAccountBO depositAccountBO = this.getDepositAccountById(accountId);
        return new DepositAccountDetailsBO(depositAccountBO, this.getBalancesList(depositAccountBO, withBalances, refTime));
    }

    public TransactionDetailsBO getTransactionById(String accountId, String transactionId) throws TransactionNotFoundException {
        try {
            DepositAccountBO account = this.getDepositAccountById(accountId);
            LedgerBO ledgerBO = this.loadLedger();
            LedgerAccountBO ledgerAccountBO = this.ledgerService.findLedgerAccount(ledgerBO, account.getIban());
            PostingLineBO line = this.postingService.findPostingLineById(ledgerAccountBO, transactionId);
            return this.transactionDetailsMapper.toTransactionSigned(line);
        }
        catch (DepositAccountNotFoundException | LedgerAccountNotFoundException | LedgerNotFoundException | PostingNotFoundException e) {
            throw new TransactionNotFoundException(e.getMessage());
        }
    }

    public List<TransactionDetailsBO> getTransactionsByDates(String accountId, LocalDateTime dateFrom, LocalDateTime dateTo) throws DepositAccountNotFoundException {
        DepositAccountBO account = this.getDepositAccountById(accountId);
        LedgerBO ledgerBO = this.loadLedger();
        try {
            LedgerAccountBO ledgerAccountBO = this.ledgerService.findLedgerAccount(ledgerBO, account.getIban());
            return this.postingService.findPostingsByDates(ledgerAccountBO, dateFrom, dateTo).stream().map(this.transactionDetailsMapper::toTransactionSigned).collect(Collectors.toList());
        }
        catch (LedgerAccountNotFoundException | LedgerNotFoundException e) {
            throw new DepositAccountUncheckedException(e.getMessage(), e);
        }
    }

    public boolean confirmationOfFunds(FundsConfirmationRequestBO requestBO) throws DepositAccountNotFoundException {
        try {
            DepositAccountDetailsBO account = this.getDepositAccountByIban(requestBO.getPsuAccount().getIban(), LocalDateTime.now(), true);
            return account.getBalances().stream().filter(b -> b.getBalanceType() == BalanceTypeBO.INTERIM_AVAILABLE).findFirst().map(b -> this.isSufficientAmountAvailable(requestBO, (BalanceBO)b)).orElse(Boolean.FALSE);
        }
        catch (DepositAccountNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DepositAccountNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public String readIbanById(String id) {
        return this.depositAccountRepository.findById((Object)id).map(DepositAccount::getIban).orElse(null);
    }

    public List<DepositAccountBO> findByAccountNumberPrefix(String accountNumberPrefix) {
        List accounts = this.depositAccountRepository.findByIbanStartingWith(accountNumberPrefix);
        return this.depositAccountMapper.toDepositAccountListBO(accounts);
    }

    public List<DepositAccountDetailsBO> findByBranch(String branch) {
        List accounts = this.depositAccountRepository.findByBranch(branch);
        List<DepositAccountBO> accountsBO = this.depositAccountMapper.toDepositAccountListBO(accounts);
        ArrayList<DepositAccountDetailsBO> accountDetails = new ArrayList<DepositAccountDetailsBO>();
        for (DepositAccountBO accountBO : accountsBO) {
            accountDetails.add(new DepositAccountDetailsBO(accountBO, Collections.emptyList()));
        }
        return accountDetails;
    }

    public void depositCash(String accountId, AmountBO amount, String recordUser) throws DepositAccountNotFoundException {
        if (amount.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw new DepositAccountUncheckedException("Deposited amount must be greater than zero");
        }
        DepositAccount depositAccount = (DepositAccount)this.depositAccountRepository.findById((Object)accountId).orElseThrow(DepositAccountNotFoundException::new);
        AccountReferenceBO accountReference = this.depositAccountMapper.toAccountReferenceBO(depositAccount);
        if (!accountReference.getCurrency().equals(amount.getCurrency())) {
            throw new DepositAccountUncheckedException("Deposited amount and account currencies are different");
        }
        LedgerBO ledger = this.loadLedger();
        LocalDateTime postingDateTime = LocalDateTime.now();
        this.depositCash(accountReference, amount, recordUser, ledger, postingDateTime);
    }

    private DepositAccount createDepositAccountObj(DepositAccountBO depositAccountBO, String userName) throws DepositAccountNotFoundException {
        DepositAccount depositAccount = this.depositAccountMapper.toDepositAccount(depositAccountBO);
        LedgerBO ledgerBO = this.loadLedger();
        String depositParentAccountNbr = this.depositAccountConfigService.getDepositParentAccount();
        LedgerAccountBO depositParentAccount = new LedgerAccountBO(depositParentAccountNbr, ledgerBO);
        LedgerAccountBO ledgerAccount = new LedgerAccountBO(depositAccount.getIban(), depositParentAccount);
        try {
            this.ledgerService.newLedgerAccount(ledgerAccount, userName);
        }
        catch (LedgerAccountNotFoundException | LedgerNotFoundException e) {
            logger.error(e.getMessage(), e);
            throw new DepositAccountNotFoundException(e.getMessage(), e);
        }
        return this.depositAccountMapper.createDepositAccountObj(depositAccount);
    }

    private List<BalanceBO> getBalancesList(DepositAccountBO d, boolean withBalances, LocalDateTime refTime) {
        return withBalances ? this.getBalances(d.getIban(), d.getCurrency(), refTime) : Collections.emptyList();
    }

    private DepositAccountBO getDepositAccountById(String accountId) throws DepositAccountNotFoundException {
        return this.depositAccountRepository.findById((Object)accountId).map(this.depositAccountMapper::toDepositAccountBO).orElseThrow(() -> new DepositAccountNotFoundException(accountId));
    }

    private List<BalanceBO> getBalances(String iban, Currency currency, LocalDateTime refTime) {
        LedgerBO ledger = this.loadLedger();
        LedgerAccountBO ledgerAccountBO = this.newLedgerAccountBOObj(ledger, iban);
        ArrayList<BalanceBO> result = new ArrayList<BalanceBO>();
        try {
            AccountStmtBO stmt = this.accountStmtService.readStmt(ledgerAccountBO, refTime);
            BalanceBO balanceBO = new BalanceBO();
            BalanceSideBO balanceSide = stmt.getAccount().getBalanceSide();
            AmountBO amount = new AmountBO();
            amount.setCurrency(currency);
            balanceBO.setAmount(amount);
            if (BalanceSideBO.Cr.equals((Object)balanceSide)) {
                amount.setAmount(stmt.creditBalance());
            } else {
                amount.setAmount(stmt.creditBalance());
            }
            balanceBO.setBalanceType(BalanceTypeBO.INTERIM_AVAILABLE);
            PostingTraceBO youngestPst = stmt.getYoungestPst();
            balanceBO.setReferenceDate(stmt.getPstTime().toLocalDate());
            if (youngestPst != null) {
                balanceBO.setLastChangeDateTime(youngestPst.getSrcPstTime());
                balanceBO.setLastCommittedTransaction(youngestPst.getSrcPstId());
            } else {
                balanceBO.setLastChangeDateTime(stmt.getPstTime());
            }
            result.add(balanceBO);
        }
        catch (BaseLineException | LedgerAccountNotFoundException | LedgerNotFoundException e) {
            logger.error(e.getMessage(), e);
            throw new DepositAccountUncheckedException(e.getMessage(), e);
        }
        return result;
    }

    private List<DepositAccountBO> getDepositAccountsByIban(List<String> ibans) {
        logger.info("Retrieving deposit accounts by list of IBANs");
        List accounts = this.depositAccountRepository.findByIbanIn(ibans);
        logger.info("{} IBANs were found", (Object)accounts.size());
        return this.depositAccountMapper.toDepositAccountListBO(accounts);
    }

    private boolean isSufficientAmountAvailable(FundsConfirmationRequestBO request, BalanceBO balance) {
        AmountBO balanceAmount = balance.getAmount();
        return Optional.ofNullable(request.getInstructedAmount()).map(r -> balanceAmount.getAmount().compareTo(r.getAmount()) >= 0).orElse(false);
    }

    private LedgerAccountBO newLedgerAccountBOObj(LedgerBO ledger, String iban) {
        LedgerAccountBO ledgerAccountBO = new LedgerAccountBO();
        ledgerAccountBO.setName(iban);
        ledgerAccountBO.setLedger(ledger);
        return ledgerAccountBO;
    }

    private void depositCash(AccountReferenceBO accountReference, AmountBO amount, String recordUser, LedgerBO ledger, LocalDateTime postingDateTime) {
        LedgerAccountBO creditAccount;
        LedgerAccountBO debitAccount;
        PostingBO posting = new PostingBO();
        posting.setLedger(ledger);
        posting.setPstTime(postingDateTime);
        posting.setOprDetails("Cash Deposit");
        posting.setOprId(Ids.id());
        posting.setPstType(PostingTypeBO.BUSI_TX);
        posting.setRecordUser(recordUser);
        String cashAccountName = this.depositAccountConfigService.getCashAccount();
        try {
            debitAccount = this.ledgerService.findLedgerAccount(ledger, cashAccountName);
        }
        catch (LedgerAccountNotFoundException | LedgerNotFoundException e) {
            throw new DepositAccountUncheckedException(e.getMessage(), e);
        }
        String debitLineId = Ids.id();
        String debitTransactionDetails = this.newTransactionDetails(amount, accountReference, postingDateTime, debitLineId);
        PostingLineBO debitLine = this.newPostingLine(debitLineId, debitAccount, amount.getAmount(), BigDecimal.ZERO, debitTransactionDetails);
        posting.getLines().add(debitLine);
        try {
            creditAccount = this.ledgerService.findLedgerAccount(ledger, accountReference.getIban());
        }
        catch (LedgerAccountNotFoundException | LedgerNotFoundException e) {
            throw new DepositAccountUncheckedException(e.getMessage(), e);
        }
        String creditLineId = Ids.id();
        String creditTransactionDetails = this.newTransactionDetails(amount, accountReference, postingDateTime, creditLineId);
        PostingLineBO creditLine = this.newPostingLine(creditLineId, creditAccount, BigDecimal.ZERO, amount.getAmount(), creditTransactionDetails);
        posting.getLines().add(creditLine);
        try {
            this.postingService.newPosting(posting);
        }
        catch (BaseLineException | DoubleEntryAccountingException | LedgerAccountNotFoundException | LedgerNotFoundException | PostingNotFoundException e) {
            throw new DepositAccountUncheckedException(e.getMessage(), e);
        }
    }

    private PostingLineBO newPostingLine(String id, LedgerAccountBO account, BigDecimal debitAmount, BigDecimal creditAmount, String details) {
        PostingLineBO debitLine = new PostingLineBO();
        debitLine.setId(id);
        debitLine.setAccount(account);
        debitLine.setDebitAmount(debitAmount);
        debitLine.setCreditAmount(creditAmount);
        debitLine.setDetails(details);
        return debitLine;
    }

    private String newTransactionDetails(AmountBO amount, AccountReferenceBO creditor, LocalDateTime postingDateTime, String postingLineId) {
        TransactionDetailsBO transactionDetails = new TransactionDetailsBO();
        transactionDetails.setTransactionId(Ids.id());
        transactionDetails.setEndToEndId(postingLineId);
        transactionDetails.setBookingDate(postingDateTime.toLocalDate());
        transactionDetails.setValueDate(postingDateTime.toLocalDate());
        transactionDetails.setTransactionAmount(amount);
        transactionDetails.setCreditorAccount(creditor);
        try {
            return this.objectMapper.writeValueAsString((Object)transactionDetails);
        }
        catch (JsonProcessingException e) {
            throw new DepositAccountUncheckedException(e.getMessage(), (Throwable)e);
        }
    }
}

