/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.exception.PaymentNotFoundException;
import de.adorsys.ledgers.deposit.api.exception.PaymentProcessingException;
import de.adorsys.ledgers.deposit.api.exception.PaymentWithIdExistsException;
import de.adorsys.ledgers.deposit.api.service.DepositAccountConfigService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.deposit.api.service.impl.AbstractServiceImpl;
import de.adorsys.ledgers.deposit.api.service.impl.PaymentExecutionService;
import de.adorsys.ledgers.deposit.api.service.mappers.PaymentMapper;
import de.adorsys.ledgers.deposit.db.domain.Payment;
import de.adorsys.ledgers.deposit.db.domain.TransactionStatus;
import de.adorsys.ledgers.deposit.db.repository.PaymentRepository;
import de.adorsys.ledgers.postings.api.service.LedgerService;
import de.adorsys.ledgers.util.Ids;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class DepositAccountPaymentServiceImpl
extends AbstractServiceImpl
implements DepositAccountPaymentService {
    private static final String PAYMENT_EXECUTION_FAILED = "Payment execution failed due to: %s, payment id: %s";
    private static final String PAYMENT_CANCELLATION_FAILED = "Can`t cancel payment id:%s, as it is already executed";
    private final PaymentRepository paymentRepository;
    private final PaymentMapper paymentMapper;
    private final PaymentExecutionService executionService;

    public DepositAccountPaymentServiceImpl(DepositAccountConfigService depositAccountConfigService, LedgerService ledgerService, PaymentRepository paymentRepository, PaymentMapper paymentMapper, PaymentExecutionService executionService) {
        super(depositAccountConfigService, ledgerService);
        this.paymentRepository = paymentRepository;
        this.paymentMapper = paymentMapper;
        this.executionService = executionService;
    }

    public TransactionStatusBO getPaymentStatusById(String paymentId) throws PaymentNotFoundException {
        Optional payment = this.paymentRepository.findById((Object)paymentId);
        TransactionStatus transactionStatus = payment.map(Payment::getTransactionStatus).orElseThrow(() -> new PaymentNotFoundException(paymentId));
        return TransactionStatusBO.valueOf((String)transactionStatus.name());
    }

    public PaymentBO getPaymentById(String paymentId) throws PaymentNotFoundException {
        return this.paymentRepository.findById((Object)paymentId).map(this.paymentMapper::toPaymentBO).orElseThrow(() -> new PaymentNotFoundException(paymentId));
    }

    public PaymentBO initiatePayment(PaymentBO payment, TransactionStatusBO status) throws PaymentWithIdExistsException {
        if (this.paymentRepository.existsById((Object)payment.getPaymentId())) {
            throw new PaymentWithIdExistsException(payment.getPaymentId());
        }
        Payment persistedPayment = this.paymentMapper.toPayment(payment);
        persistedPayment.getTargets().forEach(t -> {
            t.setPayment(persistedPayment);
            t.setPaymentId(Ids.id());
        });
        persistedPayment.setTransactionStatus(TransactionStatus.valueOf((String)status.name()));
        Payment savedPayment = (Payment)this.paymentRepository.save((Object)persistedPayment);
        return this.paymentMapper.toPaymentBO(savedPayment);
    }

    public TransactionStatusBO executePayment(String paymentId, String userName) throws PaymentProcessingException {
        Optional payment = this.paymentRepository.findByPaymentIdAndTransactionStatus(paymentId, TransactionStatus.ACTC);
        if (payment.isPresent()) {
            Payment pmt = (Payment)payment.get();
            return pmt.isInstant() ? this.executionService.executePayment(pmt, userName) : this.executionService.schedulePayment(pmt);
        }
        throw new PaymentProcessingException(String.format(PAYMENT_EXECUTION_FAILED, "Payment not found", paymentId));
    }

    public TransactionStatusBO cancelPayment(String paymentId) throws PaymentNotFoundException {
        Payment storedPayment = (Payment)this.paymentRepository.findById((Object)paymentId).orElseThrow(() -> new PaymentNotFoundException(paymentId));
        if (storedPayment.getTransactionStatus() == TransactionStatus.ACSC) {
            throw new PaymentProcessingException(String.format(PAYMENT_CANCELLATION_FAILED, paymentId));
        }
        Payment p = this.updatePaymentStatus(storedPayment, TransactionStatus.CANC);
        return TransactionStatusBO.valueOf((String)p.getTransactionStatus().name());
    }

    public String readIbanByPaymentId(String paymentId) {
        return this.paymentRepository.findById((Object)paymentId).map(p -> p.getDebtorAccount().getIban()).orElse(null);
    }

    public TransactionStatusBO updatePaymentStatusToAuthorised(String paymentId) throws PaymentNotFoundException {
        Payment payment = (Payment)this.paymentRepository.findByPaymentId(paymentId).orElseThrow(() -> new PaymentNotFoundException(paymentId));
        Payment p = this.updatePaymentStatus(payment, TransactionStatus.ACTC);
        return TransactionStatusBO.valueOf((String)p.getTransactionStatus().name());
    }

    private Payment updatePaymentStatus(Payment payment, TransactionStatus updatedStatus) {
        payment.setTransactionStatus(updatedStatus);
        return (Payment)this.paymentRepository.save((Object)payment);
    }
}

