/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.impl;

import de.adorsys.ledgers.deposit.api.exception.DepositAccountUncheckedException;
import de.adorsys.ledgers.deposit.api.service.DepositAccountInitService;
import de.adorsys.ledgers.deposit.api.service.domain.ASPSPConfigData;
import de.adorsys.ledgers.deposit.api.service.domain.ASPSPConfigSource;
import de.adorsys.ledgers.deposit.api.service.domain.LedgerAccountModel;
import de.adorsys.ledgers.postings.api.domain.AccountCategoryBO;
import de.adorsys.ledgers.postings.api.domain.BalanceSideBO;
import de.adorsys.ledgers.postings.api.domain.ChartOfAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerBO;
import de.adorsys.ledgers.postings.api.exception.ChartOfAccountNotFoundException;
import de.adorsys.ledgers.postings.api.exception.LedgerAccountNotFoundException;
import de.adorsys.ledgers.postings.api.exception.LedgerNotFoundException;
import de.adorsys.ledgers.postings.api.service.ChartOfAccountService;
import de.adorsys.ledgers.postings.api.service.LedgerService;
import de.adorsys.ledgers.util.Ids;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DepositAccountInitServiceImpl
implements DepositAccountInitService {
    private static final String SYSTEM = "System";
    private final ChartOfAccountService coaService;
    private final LedgerService ledgerService;
    private final ASPSPConfigSource configSource;

    @Autowired
    public DepositAccountInitServiceImpl(ChartOfAccountService coaService, LedgerService ledgerService, ASPSPConfigSource configSource) {
        this.coaService = coaService;
        this.ledgerService = ledgerService;
        this.configSource = configSource;
    }

    public void initConfigData() throws IOException {
        ASPSPConfigData aspspConfigData = this.configSource.aspspConfigData();
        if (this.updateRequired(aspspConfigData)) {
            try {
                this.processASPSPConfigData(aspspConfigData);
            }
            catch (ChartOfAccountNotFoundException | LedgerAccountNotFoundException | LedgerNotFoundException e) {
                throw new DepositAccountUncheckedException(e.getMessage(), e);
            }
        }
    }

    private void processASPSPConfigData(ASPSPConfigData aspspConfigData) throws LedgerNotFoundException, LedgerAccountNotFoundException, ChartOfAccountNotFoundException {
        LedgerBO ledger = this.loadASPSPAccounts(aspspConfigData.getLedger(), aspspConfigData.getCoaFile(), SYSTEM);
        List<LedgerAccountModel> coaExtensions = aspspConfigData.getCoaExtensions();
        for (LedgerAccountModel ledgerAccountModel : coaExtensions) {
            this.newLedgerAccount(ledger, ledgerAccountModel);
        }
    }

    private LedgerBO loadASPSPAccounts(String ledgerName, String coaFile, String userName) throws LedgerNotFoundException, LedgerAccountNotFoundException, ChartOfAccountNotFoundException {
        ChartOfAccountBO coa = this.getOrCreateCoa(ledgerName, userName);
        LedgerBO ledger = this.getOrCreateLedger(ledgerName, coa);
        List<LedgerAccountModel> ledgerAccounts = this.configSource.chartOfAccount(coaFile);
        for (LedgerAccountModel model : ledgerAccounts) {
            this.newLedgerAccount(ledger, model);
        }
        return ledger;
    }

    private ChartOfAccountBO getOrCreateCoa(String ledgerName, String userName) {
        return this.coaService.findChartOfAccountsByName(ledgerName).orElseGet(() -> {
            ChartOfAccountBO coa = this.createCoa(ledgerName, userName);
            return this.coaService.newChartOfAccount(coa);
        });
    }

    private LedgerBO getOrCreateLedger(String ledgerName, ChartOfAccountBO coa) throws LedgerNotFoundException, ChartOfAccountNotFoundException {
        Optional ledger = this.ledgerService.findLedgerByName(ledgerName);
        if (ledger.isPresent()) {
            return (LedgerBO)ledger.get();
        }
        LedgerBO rawLedger = this.createLedger(ledgerName, coa);
        return this.ledgerService.newLedger(rawLedger);
    }

    private LedgerAccountBO newLedgerAccount(LedgerBO ledger, LedgerAccountModel model) throws LedgerNotFoundException, LedgerAccountNotFoundException {
        try {
            return this.ledgerService.findLedgerAccount(ledger, model.getName());
        }
        catch (LedgerAccountNotFoundException ex) {
            LedgerAccountBO parent = null;
            if (model.getParent() != null) {
                try {
                    parent = this.ledgerService.findLedgerAccount(ledger, model.getParent());
                }
                catch (LedgerAccountNotFoundException | LedgerNotFoundException e) {
                    throw new IllegalStateException(String.format("Missing ledger account with id %s", model.getParent()));
                }
            }
            LedgerAccountBO la = this.newLedgerAccountObj(ledger, model, parent);
            return this.ledgerService.newLedgerAccount(la, SYSTEM);
        }
    }

    private LedgerAccountBO newLedgerAccountObj(LedgerBO ledger, LedgerAccountModel model, LedgerAccountBO parent) {
        String shortDesc = model.getShortDesc();
        String name = model.getName();
        BalanceSideBO balanceSide = model.getBalanceSide() != null ? model.getBalanceSide() : parent.getBalanceSide();
        AccountCategoryBO category = model.getCategory() != null ? model.getCategory() : parent.getCategory();
        String longDesc = null;
        LocalDateTime created = LocalDateTime.now();
        LedgerAccountBO la = new LedgerAccountBO();
        la.setId(Ids.id());
        la.setCreated(created);
        la.setShortDesc(shortDesc);
        la.setLongDesc(longDesc);
        la.setName(name);
        la.setLedger(ledger);
        la.setParent(parent);
        la.setCoa(ledger.getCoa());
        la.setBalanceSide(balanceSide);
        la.setCategory(category);
        return la;
    }

    private boolean updateRequired(ASPSPConfigData aspspConfigData) {
        return aspspConfigData.getUpdateMarkerAccountNbr() == null || this.ledgerService.findLedgerByName(aspspConfigData.getLedger()).map(l -> this.checkLedgerAccountAbsent(aspspConfigData.getUpdateMarkerAccountNbr(), (LedgerBO)l)).orElse(true) != false;
    }

    private boolean checkLedgerAccountAbsent(String updateMarkerAccountNbr, LedgerBO ledger) {
        try {
            this.ledgerService.findLedgerAccount(ledger, updateMarkerAccountNbr);
            return false;
        }
        catch (LedgerNotFoundException e) {
            throw new DepositAccountUncheckedException(e.getMessage(), (Throwable)e);
        }
        catch (LedgerAccountNotFoundException e) {
            return true;
        }
    }

    private LedgerBO createLedger(String ledgerName, ChartOfAccountBO coa) {
        LedgerBO ledger = new LedgerBO();
        ledger.setName(ledgerName);
        ledger.setShortDesc(ledgerName);
        ledger.setCoa(coa);
        return ledger;
    }

    private ChartOfAccountBO createCoa(String ledgerName, String userName) {
        ChartOfAccountBO coa = new ChartOfAccountBO();
        coa.setUserDetails(userName);
        coa.setName(ledgerName);
        coa.setShortDesc("COA: " + ledgerName);
        return coa;
    }
}

