/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.api.service.mappers;

import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.postings.api.domain.PostingLineBO;
import de.adorsys.ledgers.util.SerializationUtils;
import java.math.BigDecimal;
import org.springframework.stereotype.Component;

@Component
public class TransactionDetailsMapper {
    public TransactionDetailsBO toTransaction(PostingLineBO pl) {
        if (pl.getDetails() == null) {
            return new TransactionDetailsBO();
        }
        return (TransactionDetailsBO)SerializationUtils.readValueFromString((String)pl.getDetails(), TransactionDetailsBO.class);
    }

    public TransactionDetailsBO toTransactionSigned(PostingLineBO pl) {
        TransactionDetailsBO transaction = this.toTransaction(pl);
        if (BigDecimal.ZERO.compareTo(pl.getCreditAmount()) == 0) {
            AmountBO transactionAmount = transaction.getTransactionAmount();
            transactionAmount.setAmount(transactionAmount.getAmount().negate());
        }
        return transaction;
    }
}

